/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.emailutils.framework;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import se.unlogic.emailutils.framework.Attachment;
import se.unlogic.emailutils.framework.BaseAttachment;
import se.unlogic.emailutils.framework.ByteArrayDatasource;

public class ByteArrayAttachment
extends BaseAttachment
implements Attachment {
    private final byte[] byteArray;
    private final String contentType;
    private final String filename;

    public ByteArrayAttachment(byte[] byteArray, String contentType, String filename) {
        this.byteArray = byteArray;
        this.contentType = contentType;
        this.filename = filename;
    }

    @Override
    public MimeBodyPart getMimeBodyPart() {
        MimeBodyPart bodyPart = new MimeBodyPart();
        ByteArrayDatasource datasource = new ByteArrayDatasource(this.byteArray, this.contentType, this.filename);
        try {
            bodyPart.setDataHandler(new DataHandler((DataSource)datasource));
            bodyPart.setFileName(datasource.getName());
            this.setDisposition(bodyPart);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return bodyPart;
    }
}

