/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch.internal;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchSupport;

public abstract class AbstractElasticSearchSupport
implements ElasticSearchSupport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchSupport.class);
    protected static final String DEFAULT_CLUSTER_NAME = "qi4j_cluster";
    protected static final String DEFAULT_INDEX_NAME = "qi4j_index";
    protected static final String ENTITIES_TYPE = "qi4j_entities";
    protected static final int DEFAULT_INDEX_BUFFER_SIZE = 10;
    protected static final String DEFAULT_INDEX_REFRESH_INTERVAL = "-1";
    protected Client client;
    protected String index;
    protected boolean indexNonAggregatedAssociations;

    public final void activate() throws Exception {
        this.activateElasticSearch();
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        this.createIndexWithSettings();
        LOGGER.info("Index/Query connected to Elastic Search");
    }

    private void createIndexWithSettings() throws IOException {
        if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.index}).setIndices(new String[]{this.index}).execute().actionGet()).isExists()) {
            LOGGER.info("Will create '{}' index as it does not exists.", (Object)this.index);
            ImmutableSettings.Builder indexSettings = ImmutableSettings.settingsBuilder().loadFromSource(XContentFactory.jsonBuilder().startObject().startObject("analysis").startObject("analyzer").startObject("default").field("type", "keyword").endObject().endObject().endObject().endObject().string());
            this.client.admin().indices().prepareCreate(this.index).setIndex(this.index).setSettings((Settings.Builder)indexSettings).execute().actionGet();
            LOGGER.info("Index '{}' created.", (Object)this.index);
        }
    }

    protected abstract void activateElasticSearch() throws Exception;

    public final void passivate() throws Exception {
        this.client.close();
        this.client = null;
        this.index = null;
        this.indexNonAggregatedAssociations = false;
        this.passivateElasticSearch();
    }

    protected void passivateElasticSearch() throws Exception {
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public String entitiesType() {
        return ENTITIES_TYPE;
    }

    @Override
    public boolean indexNonAggregatedAssociations() {
        return this.indexNonAggregatedAssociations;
    }

    @Override
    public void emptyIndex() throws IOException {
        this.client.admin().indices().prepareDelete(new String[]{this.index}).execute().actionGet();
        this.createIndexWithSettings();
    }
}

