/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch.filesystem;

import java.io.File;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchConfiguration;
import se.streamsource.infrastructure.index.elasticsearch.filesystem.ESFilesystemIndexQueryService;
import se.streamsource.infrastructure.index.elasticsearch.internal.AbstractElasticSearchSupport;
import se.streamsource.streamflow.infrastructure.configuration.FileConfiguration;

public abstract class ESFilesystemSupport
extends AbstractElasticSearchSupport
implements ESFilesystemIndexQueryService {
    @This
    private Configuration<ElasticSearchConfiguration> configuration;
    @This
    private Identity hasIdentity;
    @Service
    private FileConfiguration fileConfig;
    private Node node;

    @Override
    protected void activateElasticSearch() throws Exception {
        this.configuration.refresh();
        ElasticSearchConfiguration config = (ElasticSearchConfiguration)this.configuration.configuration();
        String clusterName = config.clusterName().get() == null ? "qi4j_cluster" : (String)config.clusterName().get();
        this.index = config.index().get() == null ? "qi4j_index" : (String)config.index().get();
        this.indexNonAggregatedAssociations = (Boolean)config.indexNonAggregatedAssociations().get();
        int indexBufferSize = config.indexBufferSizePercent().get() == null || (Integer)config.indexBufferSizePercent().get() <= 0 ? 10 : (Integer)config.indexBufferSizePercent().get();
        String indexRefreshInterval = config.indexRefreshInterval().get() == null ? "-1" : (String)config.indexRefreshInterval().get();
        String identity = (String)this.hasIdentity.identity().get();
        Settings settings = ImmutableSettings.settingsBuilder().put("path.work", new File(this.fileConfig.temporaryDirectory(), identity).getAbsolutePath()).put("path.logs", new File(this.fileConfig.logDirectory(), identity).getAbsolutePath()).put("path.data", new File(this.fileConfig.dataDirectory(), identity).getAbsolutePath()).put("path.conf", new File(this.fileConfig.configurationDirectory(), identity).getAbsolutePath()).put("gateway.type", "local").put("http.enabled", ((Boolean)config.httpEnabled().get()).booleanValue()).put("index.cache.type", "weak").put("indices.memory.index_buffer_size", indexBufferSize).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.refresh_interval", indexRefreshInterval).build();
        this.node = NodeBuilder.nodeBuilder().clusterName(clusterName).settings(settings).local(true).node();
        this.client = this.node.client();
    }

    @Override
    public void passivateElasticSearch() throws Exception {
        this.node.close();
        this.node = null;
    }

    @Override
    public Client client() {
        return super.client();
    }

    @Override
    public String index() {
        return super.index();
    }

    @Override
    public String entitiesType() {
        return super.entitiesType();
    }

    @Override
    public boolean indexNonAggregatedAssociations() {
        return super.indexNonAggregatedAssociations();
    }
}

