/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch.assembly;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.qi4j.api.common.Visibility;
import org.qi4j.api.concern.GenericConcern;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchConfiguration;
import se.streamsource.infrastructure.index.elasticsearch.filesystem.ESFilesystemIndexQueryService;
import se.streamsource.infrastructure.index.elasticsearch.internal.AbstractElasticSearchAssembler;

public class ESFilesystemIndexQueryAssembler
extends AbstractElasticSearchAssembler<ESFilesystemIndexQueryAssembler> {
    @Override
    protected void doAssemble(String identity, ModuleAssembly module, Visibility visibility, ModuleAssembly configModule, Visibility configVisibility) throws AssemblyException {
        module.services(new Class[]{ESFilesystemIndexQueryService.class}).identifiedBy(identity).visibleIn(visibility).instantiateOnStartup();
        configModule.entities(new Class[]{ElasticSearchConfiguration.class}).visibleIn(configVisibility);
    }

    public static class ESPerformanceLogConcern
    extends GenericConcern {
        static Logger LOGGER = LoggerFactory.getLogger((String)ESPerformanceLogConcern.class.getName());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long start = System.nanoTime();
            List<String> methodsOfInterest = Arrays.asList("notifyChanges", "findEntity", "findEntities", "countEntities");
            try {
                Object object = ((InvocationHandler)this.next).invoke(proxy, method, args);
                return object;
            }
            finally {
                long end = System.nanoTime();
                long timeMicro = (end - start) / 1000L;
                double timeMilli = (double)timeMicro / 1000.0;
                if (methodsOfInterest.contains(method.getName())) {
                    LOGGER.info("ElasticSearch." + method.getName() + ":" + timeMilli);
                }
            }
        }
    }
}

