/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import se.streamsource.streamflow.util.Visitor;

public class Databases {
    DataSource source;

    public Databases(DataSource source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql) throws SQLException {
        try (Connection connection = this.source.getConnection();){
            int n;
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                n = stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, StatementVisitor visitor) throws SQLException {
        try (Connection connection = this.source.getConnection();){
            int n;
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                visitor.visit(stmt);
                n = stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return n;
        }
    }

    public void query(String sql, ResultSetVisitor visitor) throws SQLException {
        this.query(sql, null, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String sql, StatementVisitor statement, ResultSetVisitor resultsetVisitor) throws SQLException {
        try (Connection connection = this.source.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(sql);
            if (statement != null) {
                statement.visit(stmt);
            }
            try (ResultSet resultSet = stmt.executeQuery();){
                while (resultSet.next()) {
                    if (resultsetVisitor.visit(resultSet)) continue;
                    return;
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    public static interface ResultSetVisitor
    extends Visitor<ResultSet, SQLException> {
    }

    public static interface StatementVisitor {
        public void visit(PreparedStatement var1) throws SQLException;
    }
}

