/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.circuitbreaker.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.library.jmx.Qi4jMBeans;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.circuitbreaker.CircuitBreaker;
import se.streamsource.infrastructure.circuitbreaker.jmx.CircuitBreakerJMX;
import se.streamsource.infrastructure.circuitbreaker.service.ServiceCircuitBreaker;

@Mixins(value={Mixin.class})
public interface CircuitBreakerManagement
extends ServiceComposite,
Activatable {

    public static class Mixin
    implements Activatable {
        Map<CircuitBreaker, ObjectName> registeredCircuitBreakers = new HashMap<CircuitBreaker, ObjectName>();
        @Structure
        Application application;
        @Service
        MBeanServer server;
        @Service
        Iterable<ServiceReference<ServiceCircuitBreaker>> circuitBreakers;

        public void activate() throws Exception {
            for (ServiceReference<ServiceCircuitBreaker> circuitBreaker : this.circuitBreakers) {
                this.registerCircuitBreaker(((ServiceCircuitBreaker)circuitBreaker.get()).getCircuitBreaker(), circuitBreaker.identity());
            }
        }

        public void passivate() throws Exception {
            for (ObjectName objectName : this.registeredCircuitBreakers.values()) {
                this.server.unregisterMBean(objectName);
            }
            this.registeredCircuitBreakers.clear();
        }

        public void registerCircuitBreaker(CircuitBreaker circuitBreaker, final String name) throws JMException {
            ObjectName mbeanObjectName = null;
            ObjectName serviceName = Qi4jMBeans.findServiceName((MBeanServer)this.server, (String)this.application.name(), (String)name);
            if (serviceName != null) {
                mbeanObjectName = new ObjectName(serviceName.toString() + ",name=Circuit breaker");
            } else {
                try {
                    mbeanObjectName = new ObjectName("CircuitBreaker:name=" + name);
                }
                catch (MalformedObjectNameException e) {
                    throw new IllegalArgumentException("Illegal name:" + name);
                }
            }
            CircuitBreakerJMX bean = new CircuitBreakerJMX(circuitBreaker, name);
            try {
                this.server.registerMBean(bean, mbeanObjectName);
                this.registeredCircuitBreakers.put(circuitBreaker, mbeanObjectName);
            }
            catch (InstanceAlreadyExistsException e) {
                e.printStackTrace();
            }
            catch (MBeanRegistrationException e) {
                e.printStackTrace();
            }
            catch (NotCompliantMBeanException e) {
                e.printStackTrace();
            }
            circuitBreaker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("status")) {
                        if (evt.getNewValue().equals((Object)CircuitBreaker.Status.on)) {
                            LoggerFactory.getLogger(CircuitBreakerManagement.class).info("Circuit breaker " + name + " is now on");
                        } else {
                            LoggerFactory.getLogger(CircuitBreakerManagement.class).error("Circuit breaker " + name + " is now off");
                        }
                    }
                }
            });
        }
    }
}

