/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.util.Function;
import org.qi4j.api.util.Iterables;
import org.qi4j.spi.entity.EntityDescriptor;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.qi4j.spi.entity.EntityType;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entity.association.AssociationDescriptor;
import org.qi4j.spi.entity.association.ManyAssociationDescriptor;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.StateChangeListener;
import org.qi4j.spi.property.PropertyType;
import org.qi4j.spi.structure.ModuleSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchConfiguration;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchIndexException;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchSupport;
import se.streamsource.streamflow.util.Primitives;

@Mixins(value={Mixin.class})
public interface ElasticSearchIndexer
extends StateChangeListener {

    public static class Mixin
    implements StateChangeListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchIndexer.class);
        @Structure
        private ModuleSPI module;
        @Service
        private EntityStore entityStore;
        @This
        private ElasticSearchSupport support;
        @This
        Configuration<ElasticSearchConfiguration> config;
        private final Function<Type, Class<?>> RAW_CLASS = new Function<Type, Class<?>>(){

            public Class<?> map(Type genericType) {
                if (genericType instanceof Class) {
                    return (Class)genericType;
                }
                if (genericType instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)genericType).getRawType();
                }
                if (genericType instanceof TypeVariable) {
                    return (Class)((TypeVariable)genericType).getGenericDeclaration();
                }
                if (genericType instanceof WildcardType) {
                    return (Class)((WildcardType)genericType).getUpperBounds()[0];
                }
                if (genericType instanceof GenericArrayType) {
                    Object temp = Array.newInstance((Class)((GenericArrayType)genericType).getGenericComponentType(), 0);
                    return temp.getClass();
                }
                throw new IllegalArgumentException("Could not extract the raw class of " + genericType);
            }
        };

        public void emptyIndex() {
            this.support.client().admin().indices().prepareDelete(new String[]{this.support.index()}).execute().actionGet();
        }

        public void notifyChanges(Iterable<EntityState> changedStates) {
            block12: {
                long start1 = System.nanoTime();
                HashMap<String, EntityState> newStates = new HashMap<String, EntityState>();
                for (EntityState eState : changedStates) {
                    if (eState.status() != EntityStatus.UPDATED && eState.status() != EntityStatus.NEW) continue;
                    newStates.put(eState.identity().identity(), eState);
                }
                EntityStoreUnitOfWork uow = this.entityStore.newUnitOfWork(UsecaseBuilder.newUsecase((String)"Load associations for indexing"), this.module);
                BulkRequestBuilder bulkBuilder = this.support.client().prepareBulk();
                for (EntityState changedState : changedStates) {
                    if (!changedState.entityDescriptor().entityType().queryable()) continue;
                    switch (changedState.status()) {
                        case REMOVED: {
                            LOGGER.trace("Removing Entity State from Index: {}", (Object)changedState);
                            this.remove(bulkBuilder, changedState.identity().identity());
                            break;
                        }
                        case UPDATED: {
                            LOGGER.trace("Updating Entity State in Index: {}", (Object)changedState);
                            this.remove(bulkBuilder, changedState.identity().identity());
                            String updatedJson = this.toJSON(changedState, newStates, uow);
                            LOGGER.trace("Will index: {}", (Object)updatedJson);
                            this.index(bulkBuilder, changedState.identity().identity(), updatedJson);
                            break;
                        }
                        case NEW: {
                            LOGGER.trace("Creating Entity State in Index: {}", (Object)changedState);
                            String newJson = this.toJSON(changedState, newStates, uow);
                            LOGGER.trace("Will index: {}", (Object)newJson);
                            this.index(bulkBuilder, changedState.identity().identity(), newJson);
                            break;
                        }
                    }
                }
                uow.discard();
                long end1 = System.nanoTime();
                long timeMicro1 = (end1 - start1) / 1000L;
                double timeMilli1 = (double)timeMicro1 / 1000.0;
                LOGGER.trace("NotifyChanges first part took {}ms", (Object)timeMilli1);
                if (bulkBuilder.numberOfActions() > 0) {
                    try {
                        BulkResponse bulkResponse = (BulkResponse)bulkBuilder.execute().actionGet();
                        if (bulkResponse.hasFailures()) {
                            throw new ElasticSearchIndexException(bulkResponse.buildFailureMessage());
                        }
                        LOGGER.trace("Indexing changed Entity states took {}ms", (Object)bulkResponse.getTookInMillis());
                        if (((ElasticSearchConfiguration)this.config.configuration()).indexRefreshInterval().get() == null || "-1".equals(((ElasticSearchConfiguration)this.config.configuration()).indexRefreshInterval().get())) {
                            long start2 = System.nanoTime();
                            this.support.client().admin().indices().prepareRefresh(new String[]{this.support.index()}).execute().actionGet();
                            long end2 = System.nanoTime();
                            long timeMicro2 = (end2 - start2) / 1000L;
                            double timeMilli2 = (double)timeMicro2 / 1000.0;
                            LOGGER.trace("Indexing refresh index took {}ms", (Object)timeMilli2);
                        }
                    }
                    catch (ElasticsearchIllegalStateException esis) {
                        LOGGER.warn("Possible corrupted index state.", (Throwable)esis);
                        if (((Boolean)((ElasticSearchConfiguration)this.config.configuration()).suppressInterruptedException().get()).booleanValue()) break block12;
                        throw esis;
                    }
                }
            }
        }

        private void remove(BulkRequestBuilder bulkBuilder, String identity) {
            bulkBuilder.add(this.support.client().prepareDelete(this.support.index(), this.support.entitiesType(), identity));
        }

        private void index(BulkRequestBuilder bulkBuilder, String identity, String json) {
            bulkBuilder.add(this.support.client().prepareIndex(this.support.index(), this.support.entitiesType(), identity).setSource(json));
        }

        private String toJSON(EntityState state, Map<String, EntityState> newStates, EntityStoreUnitOfWork uow) {
            long start = System.nanoTime();
            JSONObject json = null;
            try {
                String key;
                json = new JSONObject();
                json.put("_identity", (Object)state.identity().identity());
                json.put("_modified", state.lastModified());
                json.put("_description", (Object)state.entityDescriptor().toString());
                json.put("_types", Iterables.addAll(new ArrayList(), (Iterable)Iterables.map(this.toClassName(), (Iterable)state.entityDescriptor().mixinTypes())));
                EntityType entityType = state.entityDescriptor().entityType();
                EntityDescriptor entityDesc = state.entityDescriptor();
                for (PropertyType propType : entityType.properties()) {
                    if (!propType.queryable()) continue;
                    key = propType.qualifiedName().name();
                    Object value = state.getProperty(propType.qualifiedName());
                    if (value == null || Primitives.isPrimitiveValue((Object)value)) {
                        json.put(key, value);
                        continue;
                    }
                    String serialized = propType.type().toJSON(value).toString();
                    if (serialized.startsWith("{")) {
                        json.put(key, (Object)new JSONObject(serialized));
                        continue;
                    }
                    if (serialized.startsWith("[")) {
                        json.put(key, (Object)new JSONArray(serialized));
                        continue;
                    }
                    json.put(key, (Object)serialized);
                }
                for (AssociationDescriptor assocDesc : entityDesc.state().associations()) {
                    JSONObject value;
                    if (!assocDesc.associationType().queryable()) continue;
                    key = assocDesc.qualifiedName().name();
                    EntityReference associated = state.getAssociation(assocDesc.qualifiedName());
                    if (associated == null) {
                        value = null;
                    } else if (assocDesc.isAggregated() || this.support.indexNonAggregatedAssociations()) {
                        if (newStates.containsKey(associated.identity())) {
                            value = new JSONObject(this.toJSON(newStates.get(associated.identity()), newStates, uow));
                        } else {
                            EntityState assocState = uow.getEntityState(EntityReference.parseEntityReference((String)associated.identity()));
                            value = new JSONObject(this.toJSON(assocState, newStates, uow));
                        }
                    } else {
                        value = new JSONObject(Collections.singletonMap("identity", associated.identity()));
                    }
                    json.put(key, value);
                }
                for (ManyAssociationDescriptor manyAssocDesc : entityDesc.state().manyAssociations()) {
                    if (!manyAssocDesc.manyAssociationType().queryable()) continue;
                    key = manyAssocDesc.qualifiedName().name();
                    JSONArray array = new JSONArray();
                    ManyAssociationState associateds = state.getManyAssociation(manyAssocDesc.qualifiedName());
                    for (EntityReference associated : associateds) {
                        if (manyAssocDesc.isAggregated() || this.support.indexNonAggregatedAssociations()) {
                            if (newStates.containsKey(associated.identity())) {
                                array.put((Object)new JSONObject(this.toJSON(newStates.get(associated.identity()), newStates, uow)));
                                continue;
                            }
                            EntityState assocState = uow.getEntityState(EntityReference.parseEntityReference((String)associated.identity()));
                            array.put((Object)new JSONObject(this.toJSON(assocState, newStates, uow)));
                            continue;
                        }
                        array.put((Object)new JSONObject(Collections.singletonMap("identity", associated.identity())));
                    }
                    json.put(key, (Object)array);
                }
                return json.toString();
            }
            catch (JSONException e) {
                throw new ElasticSearchIndexException("Could not index EntityState", e);
            }
        }

        private Function<Type, String> toClassName() {
            return new Function<Type, String>(){

                public String map(Type type) {
                    return ((Class)Mixin.this.RAW_CLASS.map((Object)type)).getName();
                }
            };
        }
    }
}

