/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch;

import java.util.Map;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.qi4j.api.common.Optional;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.query.grammar.BooleanExpression;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.util.Function;
import org.qi4j.api.util.Iterables;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.query.EntityFinder;
import org.qi4j.spi.query.EntityFinderException;
import org.qi4j.spi.query.NamedEntityFinder;
import org.qi4j.spi.query.NamedQueryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchQueryParserImpl;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchSupport;

@Mixins(value={Mixin.class, NamedEntityFinderMixin.class})
public interface ElasticSearchFinder
extends EntityFinder,
NamedEntityFinder {

    public static class NamedEntityFinderMixin
    implements NamedEntityFinder {
        private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchFinder.class);
        @This
        private ElasticSearchSupport support;

        public Iterable<EntityReference> findEntities(NamedQueryDescriptor descriptor, String resultType, @Optional Map<String, Object> variables, @Optional OrderBy[] orderBySegments, @Optional Integer firstResult, @Optional Integer maxResults) throws EntityFinderException {
            return null;
        }

        public EntityReference findEntity(NamedQueryDescriptor descriptor, String resultType, Map<String, Object> variables) throws EntityFinderException {
            SearchRequestBuilder request = this.support.client().prepareSearch(new String[]{this.support.index()});
            request.setQuery(descriptor.compose(variables, null, null, null));
            request.setSize(1);
            LOGGER.debug("Will search Entity: {}", (Object)request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.getHits().totalHits() == 1L) {
                return EntityReference.parseEntityReference((String)response.getHits().getAt(0).id());
            }
            return null;
        }

        public long countEntities(NamedQueryDescriptor descriptor, String resultType, @Optional Map<String, Object> variables) throws EntityFinderException {
            return 0L;
        }

        public String showQuery(NamedQueryDescriptor descriptor) {
            return descriptor.compose(null, null, null, null);
        }
    }

    public static class Mixin
    implements EntityFinder {
        private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchFinder.class);
        @This
        private ElasticSearchSupport support;
        @Structure
        Qi4jSPI qi4j;

        public Iterable<EntityReference> findEntities(Class<?> resultType, BooleanExpression whereClause, OrderBy[] orderBySegments, Integer firstResult, Integer maxResults) throws EntityFinderException {
            SearchRequestBuilder request = this.support.client().prepareSearch(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = new ElasticSearchQueryParserImpl().getQueryBuilder(filterBuilder, whereClause);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            if (firstResult != null) {
                request.setFrom(firstResult.intValue());
            }
            if (maxResults != null) {
                request.setSize(maxResults.intValue());
            } else {
                request.setSize(Integer.MAX_VALUE);
            }
            if (orderBySegments != null) {
                for (OrderBy order : orderBySegments) {
                    FieldSortBuilder sortBuilder = new FieldSortBuilder(order.propertyReference().propertyName());
                    sortBuilder.order(order.order() == OrderBy.Order.ASCENDING ? SortOrder.ASC : SortOrder.DESC);
                    sortBuilder.ignoreUnmapped(true);
                    sortBuilder.missing((Object)"_first");
                    request.addSort((SortBuilder)sortBuilder);
                }
            }
            LOGGER.debug("Will search Entities: {}", (Object)request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            return Iterables.map((Function)new Function<SearchHit, EntityReference>(){

                public EntityReference map(SearchHit from) {
                    return EntityReference.parseEntityReference((String)from.id());
                }
            }, (Iterable)response.getHits());
        }

        public EntityReference findEntity(Class<?> resultType, BooleanExpression whereClause) throws EntityFinderException {
            SearchRequestBuilder request = this.support.client().prepareSearch(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = new ElasticSearchQueryParserImpl().getQueryBuilder(filterBuilder, whereClause);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            request.setSize(1);
            LOGGER.debug("Will search Entity: {}", (Object)request);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            if (response.getHits().totalHits() == 1L) {
                return EntityReference.parseEntityReference((String)response.getHits().getAt(0).id());
            }
            return null;
        }

        public long countEntities(Class<?> resultType, BooleanExpression whereClause) throws EntityFinderException {
            CountRequestBuilder request = this.support.client().prepareCount(new String[]{this.support.index()});
            AndFilterBuilder filterBuilder = Mixin.baseFilters(resultType);
            QueryBuilder queryBuilder = new ElasticSearchQueryParserImpl().getQueryBuilder(filterBuilder, whereClause);
            request.setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder));
            LOGGER.debug("Will count Entities: {}", (Object)request);
            CountResponse count = (CountResponse)request.execute().actionGet();
            return count.getCount();
        }

        private static AndFilterBuilder baseFilters(Class<?> resultType) {
            return FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"_types", (String)resultType.getName())});
        }
    }
}

