/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.circuitbreaker.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import se.streamsource.infrastructure.circuitbreaker.CircuitBreaker;
import se.streamsource.infrastructure.circuitbreaker.jmx.CircuitBreakerJMXMBean;

public class CircuitBreakerJMX
extends NotificationBroadcasterSupport
implements CircuitBreakerJMXMBean {
    CircuitBreaker circuitBreaker;
    long seqNr = 1L;

    public CircuitBreakerJMX(CircuitBreaker circuitBreaker, final String name) {
        super(new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "CircuitBreaker status has changed"));
        this.circuitBreaker = circuitBreaker;
        circuitBreaker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("status")) {
                    if (evt.getNewValue().equals((Object)CircuitBreaker.Status.on)) {
                        CircuitBreakerJMX.this.sendNotification(new AttributeChangeNotification(CircuitBreakerJMX.this, CircuitBreakerJMX.this.seqNr++, System.currentTimeMillis(), "Status changed for " + name, "Status", String.class.getName(), (Object)CircuitBreaker.Status.off, (Object)CircuitBreaker.Status.on));
                    } else {
                        CircuitBreakerJMX.this.sendNotification(new AttributeChangeNotification(CircuitBreakerJMX.this, CircuitBreakerJMX.this.seqNr++, System.currentTimeMillis(), "Status changed for " + name, "Status", String.class.getName(), (Object)CircuitBreaker.Status.on, (Object)CircuitBreaker.Status.off));
                    }
                }
            }
        });
    }

    @Override
    public String getStatus() {
        return this.circuitBreaker.getStatus().name();
    }

    @Override
    public int getThreshold() {
        return this.circuitBreaker.getThreshold();
    }

    @Override
    public double getServiceLevel() {
        return this.circuitBreaker.getServiceLevel();
    }

    @Override
    public String getLastErrorMessage() {
        return this.circuitBreaker.getLastThrowable() == null ? "" : this.errorMessage(this.circuitBreaker.getLastThrowable());
    }

    private String errorMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.getClass().getSimpleName();
        }
        if (throwable.getCause() != null) {
            return message + ":" + this.errorMessage(throwable.getCause());
        }
        return message;
    }

    @Override
    public String getTrippedOn() {
        Date trippedOn = this.circuitBreaker.getTrippedOn();
        return trippedOn == null ? "" : DateFormat.getDateTimeInstance().format(trippedOn);
    }

    @Override
    public String getEnableOn() {
        Date trippedOn = this.circuitBreaker.getEnableOn();
        return trippedOn == null ? "" : DateFormat.getDateTimeInstance().format(trippedOn);
    }

    @Override
    public String turnOn() {
        try {
            this.circuitBreaker.turnOn();
            return "Circuit breaker has been turned on";
        }
        catch (PropertyVetoException e) {
            return "Could not turn on circuit breaker:" + this.getLastErrorMessage();
        }
    }

    @Override
    public void trip() {
        this.circuitBreaker.trip();
    }
}

