/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.circuitbreaker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Date;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;

public class CircuitBreaker {
    private int threshold;
    private long timeout;
    private Specification<Throwable> allowedThrowables;
    private int countDown;
    private long trippedOn = -1L;
    private long enableOn = -1L;
    private Status status = Status.on;
    private Throwable lastThrowable;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    VetoableChangeSupport vcs = new VetoableChangeSupport(this);

    public CircuitBreaker(int threshold, long timeout, Specification<Throwable> allowedThrowables) {
        this.threshold = threshold;
        this.countDown = threshold;
        this.timeout = timeout;
        this.allowedThrowables = allowedThrowables;
    }

    public CircuitBreaker(int threshold, long timeout) {
        this(threshold, timeout, (Specification<Throwable>)Specifications.not((Specification)Specifications.TRUE()));
    }

    public CircuitBreaker() {
        this(1, 300000L);
    }

    public synchronized void trip() {
        if (this.status == Status.on) {
            if (this.countDown != 0) {
                int oldCountDown = this.countDown;
                this.countDown = 0;
                this.pcs.firePropertyChange("serviceLevel", (double)oldCountDown / (double)this.threshold, (double)this.countDown / (double)this.threshold);
            }
            this.status = Status.off;
            this.lastThrowable = new Exception("Manually tripped");
            this.trippedOn = System.currentTimeMillis();
            this.enableOn = this.trippedOn + this.timeout;
            this.pcs.firePropertyChange("status", (Object)Status.on, (Object)Status.off);
        }
    }

    public synchronized void turnOn() throws PropertyVetoException {
        if (this.status == Status.off) {
            try {
                this.vcs.fireVetoableChange("status", (Object)Status.off, (Object)Status.on);
                this.status = Status.on;
                this.countDown = this.threshold;
                this.trippedOn = -1L;
                this.enableOn = -1L;
                this.lastThrowable = null;
                this.pcs.firePropertyChange("status", (Object)Status.off, (Object)Status.on);
            }
            catch (PropertyVetoException e) {
                this.enableOn = System.currentTimeMillis() + this.timeout;
                this.lastThrowable = e.getCause() != null ? e.getCause() : e;
                throw e;
            }
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public synchronized Throwable getLastThrowable() {
        return this.lastThrowable;
    }

    public synchronized double getServiceLevel() {
        return (double)this.countDown / (double)this.threshold;
    }

    public synchronized Status getStatus() {
        if (this.status == Status.off && System.currentTimeMillis() > this.enableOn) {
            try {
                this.turnOn();
            }
            catch (PropertyVetoException e) {
                this.lastThrowable = e.getCause() != null ? e.getCause() : e;
            }
        }
        return this.status;
    }

    public Date getTrippedOn() {
        return this.trippedOn == -1L ? null : new Date(this.trippedOn);
    }

    public Date getEnableOn() {
        return this.enableOn == -1L ? null : new Date(this.enableOn);
    }

    public boolean isOn() {
        return this.getStatus().equals((Object)Status.on);
    }

    public synchronized void throwable(Throwable throwable) {
        if (this.status == Status.on) {
            if (this.allowedThrowables.satisfiedBy((Object)throwable)) {
                this.success();
            } else {
                --this.countDown;
                this.lastThrowable = throwable;
                this.pcs.firePropertyChange("serviceLevel", (double)(this.countDown + 1) / (double)this.threshold, (double)this.countDown / (double)this.threshold);
                if (this.countDown == 0) {
                    this.trip();
                }
            }
        }
    }

    public synchronized void success() {
        if (this.status == Status.on && this.countDown < this.threshold) {
            ++this.countDown;
            this.pcs.firePropertyChange("serviceLevel", (double)(this.countDown - 1) / (double)this.threshold, (double)this.countDown / (double)this.threshold);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vcl) {
        this.vcs.addVetoableChangeListener(vcl);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vcl) {
        this.vcs.removeVetoableChangeListener(vcl);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public static enum Status {
        off,
        on;

    }
}

