/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.sql.DataSource;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.entity.Entity;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.association.EntityStateHolder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityDescriptor;
import org.qi4j.spi.property.PropertyType;
import org.qi4j.spi.structure.ModuleSPI;
import se.streamsource.infrastructure.database.DataSourceConfiguration;
import se.streamsource.infrastructure.database.DataSourceService;

@Mixins(value={Mixin.class})
public interface DatasourceConfigurationManagerService
extends ServiceComposite,
Activatable {

    public static class Mixin
    implements Activatable {
        @Structure
        Module module;
        @Service
        MBeanServer server;
        @Structure
        Qi4jSPI spi;
        @Structure
        Application application;
        @Service
        Iterable<ServiceReference<DataSource>> dataSources;
        @Optional
        @Service
        ServiceReference<DataSourceService> dataSourceService;
        private List<ObjectName> configurationNames = new ArrayList<ObjectName>();

        public void activate() throws Exception {
            this.exportDataSources();
        }

        private void exportDataSources() throws MalformedObjectNameException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
            for (ServiceReference<DataSource> dataSource : this.dataSources) {
                String name = dataSource.identity();
                try {
                    ((DataSourceService)this.dataSourceService.get()).getConfiguration(name);
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
                ModuleSPI module = (ModuleSPI)this.spi.getModule(dataSource);
                EntityDescriptor descriptor = module.entityDescriptor(DataSourceConfiguration.class.getName());
                ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
                HashMap<String, QualifiedName> properties = new HashMap<String, QualifiedName>();
                for (PropertyType propertyType : descriptor.entityType().properties()) {
                    if (propertyType.propertyType() != PropertyType.PropertyTypeEnum.MUTABLE) continue;
                    String propertyName = propertyType.qualifiedName().name();
                    String type = propertyType.type().type().name();
                    attributes.add(new MBeanAttributeInfo(propertyName, type, propertyName, true, true, type.equals("java.lang.Boolean")));
                    properties.put(propertyName, propertyType.qualifiedName());
                }
                ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
                operations.add(new MBeanOperationInfo("restart", "Restart DataSource", new MBeanParameterInfo[0], "void", 2));
                MBeanInfo mbeanInfo = new MBeanInfo(DataSourceConfiguration.class.getName(), name, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
                ConfigurableDataSource mbean = new ConfigurableDataSource(this.dataSourceService, mbeanInfo, name, properties);
                ObjectName configurableDataSourceName = new ObjectName("Qi4j:application=" + this.application.name() + ",class=Datasource,name=" + name);
                this.server.registerMBean(mbean, configurableDataSourceName);
                this.configurationNames.add(configurableDataSourceName);
            }
        }

        public void passivate() throws Exception {
            for (ObjectName configurableServiceName : this.configurationNames) {
                this.server.unregisterMBean(configurableServiceName);
            }
        }

        class ConfigurableDataSource
        extends EditableConfiguration {
            private ServiceReference<DataSourceService> service;

            ConfigurableDataSource(ServiceReference<DataSourceService> service, MBeanInfo info, String identity, Map<String, QualifiedName> propertyNames) {
                super(info, identity, propertyNames);
                this.service = service;
            }

            @Override
            public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
                if (s.equals("restart")) {
                    try {
                        if (this.service.isActive()) {
                            ((Activatable)this.service).passivate();
                            ((Activatable)this.service).activate();
                        }
                        return "Service restarted";
                    }
                    catch (Exception e) {
                        return "Could not restart service:" + e.getMessage();
                    }
                }
                return "Unknown operation";
            }
        }

        abstract class EditableConfiguration
        implements DynamicMBean {
            MBeanInfo info;
            String identity;
            Map<String, QualifiedName> propertyNames;

            EditableConfiguration(MBeanInfo info, String identity, Map<String, QualifiedName> propertyNames) {
                this.info = info;
                this.identity = identity;
                this.propertyNames = propertyNames;
            }

            @Override
            public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
                UnitOfWork uow = Mixin.this.module.unitOfWorkFactory().newUnitOfWork();
                try {
                    Entity configuration = (Entity)uow.get(Entity.class, this.identity);
                    EntityStateHolder state = Mixin.this.spi.getState((EntityComposite)configuration);
                    QualifiedName qualifiedName = this.propertyNames.get(name);
                    Property property = state.getProperty(qualifiedName);
                    Object object = property.get();
                    return object;
                }
                catch (Exception ex) {
                    throw new ReflectionException(ex, "Could not get attribute " + name);
                }
                finally {
                    uow.discard();
                }
            }

            @Override
            public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
                UnitOfWork uow = Mixin.this.module.unitOfWorkFactory().newUnitOfWork();
                try {
                    Entity configuration = (Entity)uow.get(Entity.class, this.identity);
                    EntityStateHolder state = Mixin.this.spi.getState((EntityComposite)configuration);
                    QualifiedName qualifiedName = this.propertyNames.get(attribute.getName());
                    Property property = state.getProperty(qualifiedName);
                    property.set(attribute.getValue());
                    uow.complete();
                }
                catch (Exception ex) {
                    uow.discard();
                }
            }

            @Override
            public AttributeList getAttributes(String[] names) {
                AttributeList list = new AttributeList();
                for (String name : names) {
                    try {
                        Object value = this.getAttribute(name);
                        list.add(new Attribute(name, value));
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (MBeanException e) {
                        e.printStackTrace();
                    }
                    catch (ReflectionException e) {
                        e.printStackTrace();
                    }
                }
                return list;
            }

            @Override
            public AttributeList setAttributes(AttributeList attributeList) {
                AttributeList list = new AttributeList();
                for (int i = 0; i < list.size(); ++i) {
                    Attribute attribute = (Attribute)list.get(i);
                    try {
                        this.setAttribute(attribute);
                        list.add(attribute);
                        continue;
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvalidAttributeValueException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (MBeanException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (ReflectionException e) {
                        e.printStackTrace();
                    }
                }
                return list;
            }

            @Override
            public MBeanInfo getMBeanInfo() {
                return this.info;
            }
        }
    }
}

