/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.LoggerFactory;

public class MBeanTracker {
    private boolean started = false;
    private ObjectName pattern;
    private MBeanServer server;
    private List<TrackerCallback> callbacks = new ArrayList<TrackerCallback>();
    private List<ObjectName> tracked = Collections.synchronizedList(new ArrayList());
    private RegistrationListener registrationListener;

    public MBeanTracker(ObjectName pattern, MBeanServer server) {
        this.pattern = pattern;
        this.server = server;
    }

    public MBeanTracker registerCallback(TrackerCallback callback) {
        ArrayList<TrackerCallback> newList = new ArrayList<TrackerCallback>(this.callbacks);
        newList.add(callback);
        this.callbacks = newList;
        return this;
    }

    public MBeanTracker unregisterCallback(TrackerCallback callback) {
        ArrayList<TrackerCallback> newList = new ArrayList<TrackerCallback>(this.callbacks);
        newList.remove(callback);
        this.callbacks = newList;
        return this;
    }

    public Iterable<ObjectName> getTracked() {
        return this.tracked;
    }

    public void start() {
        if (!this.started) {
            try {
                this.registrationListener = new RegistrationListener();
                this.server.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.registrationListener, null, null);
                for (ObjectName objectName : this.server.queryNames(this.pattern, null)) {
                    for (TrackerCallback callback : this.callbacks) {
                        try {
                            this.tracked.add(objectName);
                            callback.addedMBean(objectName, this.server);
                        }
                        catch (Throwable throwable) {
                            LoggerFactory.getLogger(MBeanTracker.class).error("Tracker callback threw exception", throwable);
                        }
                    }
                }
                this.started = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.started) {
            try {
                this.server.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this.registrationListener);
                for (ObjectName objectName : this.server.queryNames(this.pattern, null)) {
                    for (TrackerCallback callback : this.callbacks) {
                        try {
                            callback.removedMBean(objectName, this.server);
                            this.tracked.remove(objectName);
                        }
                        catch (Throwable throwable) {
                            LoggerFactory.getLogger(MBeanTracker.class).error("Tracker callback threw exception", throwable);
                        }
                    }
                }
                this.started = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class RegistrationListener
    implements NotificationListener {
        RegistrationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object o) {
            block10: {
                if (!(notification instanceof MBeanServerNotification)) break block10;
                MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
                if (MBeanTracker.this.pattern.apply(serverNotification.getMBeanName())) {
                    if (serverNotification.getType().equals("JMX.mbean.registered")) {
                        for (TrackerCallback callback : MBeanTracker.this.callbacks) {
                            try {
                                MBeanTracker.this.tracked.add(serverNotification.getMBeanName());
                                callback.addedMBean(serverNotification.getMBeanName(), MBeanTracker.this.server);
                            }
                            catch (Throwable throwable) {
                                LoggerFactory.getLogger(MBeanTracker.class).error("Tracker callback threw exception", throwable);
                            }
                        }
                    } else if (serverNotification.getType().equals("JMX.mbean.unregistered")) {
                        for (TrackerCallback callback : MBeanTracker.this.callbacks) {
                            try {
                                callback.removedMBean(serverNotification.getMBeanName(), MBeanTracker.this.server);
                                MBeanTracker.this.tracked.remove(serverNotification.getMBeanName());
                            }
                            catch (Throwable throwable) {
                                LoggerFactory.getLogger(MBeanTracker.class).error("Tracker callback threw exception", throwable);
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface TrackerCallback {
        public void addedMBean(ObjectName var1, MBeanServer var2) throws Throwable;

        public void removedMBean(ObjectName var1, MBeanServer var2) throws Throwable;
    }
}

