/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.index.elasticsearch;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.query.grammar.AssociationIsNotNullPredicate;
import org.qi4j.api.query.grammar.AssociationIsNullPredicate;
import org.qi4j.api.query.grammar.BooleanExpression;
import org.qi4j.api.query.grammar.ComparisonPredicate;
import org.qi4j.api.query.grammar.Conjunction;
import org.qi4j.api.query.grammar.ContainsAllPredicate;
import org.qi4j.api.query.grammar.ContainsPredicate;
import org.qi4j.api.query.grammar.Disjunction;
import org.qi4j.api.query.grammar.EqualsPredicate;
import org.qi4j.api.query.grammar.GreaterOrEqualPredicate;
import org.qi4j.api.query.grammar.GreaterThanPredicate;
import org.qi4j.api.query.grammar.LessOrEqualPredicate;
import org.qi4j.api.query.grammar.LessThanPredicate;
import org.qi4j.api.query.grammar.ManyAssociationContainsPredicate;
import org.qi4j.api.query.grammar.MatchesPredicate;
import org.qi4j.api.query.grammar.Negation;
import org.qi4j.api.query.grammar.NotEqualsPredicate;
import org.qi4j.api.query.grammar.PropertyIsNotNullPredicate;
import org.qi4j.api.query.grammar.PropertyIsNullPredicate;
import org.qi4j.api.query.grammar.SingleValueExpression;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.value.ValueDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.index.elasticsearch.ElasticSearchQueryParser;

public class ElasticSearchQueryParserImpl
implements ElasticSearchQueryParser {
    @Structure
    Qi4jSPI qi4jSPI;
    private Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    private static ThreadLocal<DateFormat> ISO8601_UTC = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };

    @Override
    public QueryBuilder getQueryBuilder(AndFilterBuilder baseFilter, BooleanExpression whereClause) {
        if (whereClause == null) {
            return QueryBuilders.matchAllQuery();
        }
        this.processFilter((FilterBuilder)baseFilter, whereClause);
        return QueryBuilders.matchAllQuery();
    }

    private void processFilter(FilterBuilder filterBuilder, BooleanExpression expression) {
        if (expression instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)expression;
            AndFilterBuilder andFilterBuilder = new AndFilterBuilder(new FilterBuilder[0]);
            this.processFilter((FilterBuilder)andFilterBuilder, conjunction.leftSideExpression());
            this.processFilter((FilterBuilder)andFilterBuilder, conjunction.rightSideExpression());
            this.addFilter((FilterBuilder)andFilterBuilder, filterBuilder);
        } else if (expression instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)expression;
            OrFilterBuilder orFilterBuilder = new OrFilterBuilder(new FilterBuilder[0]);
            this.processFilter((FilterBuilder)orFilterBuilder, disjunction.leftSideExpression());
            this.processFilter((FilterBuilder)orFilterBuilder, disjunction.rightSideExpression());
            this.addFilter((FilterBuilder)orFilterBuilder, filterBuilder);
        } else if (expression instanceof Negation) {
            this.processNegation(filterBuilder, ((Negation)expression).expression());
        } else if (expression instanceof MatchesPredicate) {
            this.processMatchesPredicate(filterBuilder, (MatchesPredicate)expression);
        } else if (expression instanceof ComparisonPredicate) {
            this.processComparisonPredicate(filterBuilder, (ComparisonPredicate)expression);
        } else if (expression instanceof ManyAssociationContainsPredicate) {
            this.processManyAssociationContainsPredicate(filterBuilder, (ManyAssociationContainsPredicate)expression);
        } else if (expression instanceof PropertyIsNullPredicate) {
            this.processIsNullPredicate(filterBuilder, (PropertyIsNullPredicate)expression);
        } else if (expression instanceof PropertyIsNotNullPredicate) {
            this.processIsNotNullPredicate(filterBuilder, (PropertyIsNotNullPredicate)expression);
        } else if (expression instanceof AssociationIsNullPredicate) {
            this.processIsNullPredicate(filterBuilder, (AssociationIsNullPredicate)expression);
        } else if (expression instanceof AssociationIsNotNullPredicate) {
            this.processIsNotNullPredicate(filterBuilder, (AssociationIsNotNullPredicate)expression);
        } else if (expression instanceof ContainsPredicate) {
            this.processContainsPredicate(filterBuilder, (ContainsPredicate)expression);
        } else if (expression instanceof ContainsAllPredicate) {
            this.processContainsAllPredicate(filterBuilder, (ContainsAllPredicate)expression);
        } else {
            throw new UnsupportedOperationException("Expression " + expression + " is not supported");
        }
    }

    private void processNegation(FilterBuilder filterBuilder, BooleanExpression expression) {
        if (expression instanceof PropertyIsNotNullPredicate) {
            this.LOGGER.trace("Processing PropertyNotNullSpecification {}", (Object)expression);
            this.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)((PropertyIsNotNullPredicate)expression).propertyReference().propertyName()), filterBuilder);
        } else if (expression instanceof AssociationIsNotNullPredicate) {
            this.LOGGER.trace("Processing AssociationNotNullSpecification {}", (Object)expression);
            this.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)(((AssociationIsNotNullPredicate)expression).associationReference().associationName() + ".identity")), filterBuilder);
        } else {
            this.LOGGER.trace("Processing NotSpecification {}", (Object)expression);
            AndFilterBuilder operandFilter = new AndFilterBuilder(new FilterBuilder[0]);
            this.processFilter((FilterBuilder)operandFilter, expression);
            this.addFilter((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)operandFilter), filterBuilder);
        }
    }

    private void processContainsAllPredicate(FilterBuilder filterBuilder, ContainsAllPredicate<?, ?> predicate) {
        this.LOGGER.trace("Processing ContainsAllSpecification {}", predicate);
        String name = predicate.propertyReference().propertyName();
        AndFilterBuilder contAllFilter = new AndFilterBuilder(new FilterBuilder[0]);
        for (Object value : (Collection)((SingleValueExpression)predicate.valueExpression()).value()) {
            if (value instanceof ValueComposite) {
                ValueComposite valueComposite = (ValueComposite)value;
                ValueDescriptor valueDescriptor = this.qi4jSPI.getValueDescriptor(valueComposite);
                throw new UnsupportedOperationException("ElasticSearch Index/Query does not support complex queries, ie. queries by 'example value'.");
            }
            contAllFilter.add((FilterBuilder)FilterBuilders.termFilter((String)name, (String)this.toString(value)));
        }
        this.addFilter((FilterBuilder)contAllFilter, filterBuilder);
    }

    private void processContainsPredicate(FilterBuilder filterBuilder, ContainsPredicate<?, ?> predicate) {
        this.LOGGER.trace("Processing ContainsSpecification {}", predicate);
        String name = predicate.propertyReference().propertyName();
        if (((SingleValueExpression)predicate.valueExpression()).value() instanceof ValueComposite) {
            ValueComposite value = (ValueComposite)((SingleValueExpression)predicate.valueExpression()).value();
            ValueDescriptor valueDescriptor = this.qi4jSPI.getValueDescriptor(value);
            throw new UnsupportedOperationException("ElasticSearch Index/Query does not support complex queries, ie. queries by 'example value'.");
        }
        String value = this.toString(((SingleValueExpression)predicate.valueExpression()).value());
        this.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (String)value), filterBuilder);
    }

    private void processMatchesPredicate(FilterBuilder filterBuilder, MatchesPredicate predicate) {
        this.LOGGER.trace("Processing MatchesSpecification {}", (Object)predicate);
        String name = "";
        name = predicate.propertyReference().traversedAssociation() != null ? predicate.propertyReference().traversedAssociation().associationName() + ".identity" : (predicate.propertyReference().traversedProperty() != null ? predicate.propertyReference().traversedProperty().propertyName() + "." + predicate.propertyReference().propertyName() : predicate.propertyReference().propertyName());
        String value = this.toString(((SingleValueExpression)predicate.valueExpression()).value()).replace('^', '.');
        this.addFilter((FilterBuilder)FilterBuilders.regexpFilter((String)name, (String)value), filterBuilder);
    }

    private void processComparisonPredicate(FilterBuilder filterBuilder, ComparisonPredicate predicate) {
        this.LOGGER.trace("Processing ComparisonPredicate {}", (Object)predicate);
        String name = "";
        name = predicate.propertyReference().traversedAssociation() != null ? predicate.propertyReference().traversedAssociation().associationName() + ".identity" : (predicate.propertyReference().traversedProperty() != null ? predicate.propertyReference().traversedProperty().propertyName() + "." + predicate.propertyReference().propertyName() : predicate.propertyReference().propertyName());
        String value = this.toString(((SingleValueExpression)predicate.valueExpression()).value());
        if (predicate instanceof EqualsPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (String)value), filterBuilder);
        } else if (predicate instanceof NotEqualsPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (String)value)), filterBuilder);
        } else if (predicate instanceof GreaterOrEqualPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).from((Object)value).includeLower(true), filterBuilder);
        } else if (predicate instanceof GreaterThanPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).from((Object)value).includeLower(false), filterBuilder);
        } else if (predicate instanceof LessOrEqualPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).to((Object)value).includeUpper(true), filterBuilder);
        } else if (predicate instanceof LessThanPredicate) {
            this.addFilter((FilterBuilder)FilterBuilders.rangeFilter((String)name).to((Object)value).includeUpper(false), filterBuilder);
        } else {
            throw new UnsupportedOperationException("Query specification unsupported by Elastic Search: " + predicate.getClass() + ": " + predicate);
        }
    }

    private void processManyAssociationContainsPredicate(FilterBuilder filterBuilder, ManyAssociationContainsPredicate predicate) {
        this.LOGGER.trace("Processing ManyAssociationContainsSpecification {}", (Object)predicate);
        String name = predicate.associationReference().associationName() + ".identity";
        String value = this.toString(((SingleValueExpression)predicate.valueExpression()).value());
        this.addFilter((FilterBuilder)FilterBuilders.termFilter((String)name, (String)value), filterBuilder);
    }

    private void processIsNullPredicate(FilterBuilder filterBuilder, PropertyIsNullPredicate predicate) {
        this.LOGGER.trace("Processing PropertyNullSpecification {}", (Object)predicate);
        this.addFilter((FilterBuilder)FilterBuilders.missingFilter((String)predicate.propertyReference().propertyName()), filterBuilder);
    }

    private void processIsNullPredicate(FilterBuilder filterBuilder, AssociationIsNullPredicate predicate) {
        this.LOGGER.trace("Processing AssociationNullSpecification {}", (Object)predicate);
        this.addFilter((FilterBuilder)FilterBuilders.missingFilter((String)(predicate.associationReference().associationName() + ".identity")), filterBuilder);
    }

    private void processIsNotNullPredicate(FilterBuilder filterBuilder, PropertyIsNotNullPredicate predicate) {
        this.LOGGER.trace("Processing PropertyNullSpecification {}", (Object)predicate);
        this.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)predicate.propertyReference().propertyName()), filterBuilder);
    }

    private void processIsNotNullPredicate(FilterBuilder filterBuilder, AssociationIsNotNullPredicate predicate) {
        this.LOGGER.trace("Processing AssociationNullSpecification {}", (Object)predicate);
        this.addFilter((FilterBuilder)FilterBuilders.existsFilter((String)(predicate.associationReference().associationName() + ".identity")), filterBuilder);
    }

    private void addFilter(FilterBuilder filter, FilterBuilder into) {
        if (into instanceof AndFilterBuilder) {
            ((AndFilterBuilder)into).add(filter);
        } else if (into instanceof OrFilterBuilder) {
            ((OrFilterBuilder)into).add(filter);
        } else {
            throw new UnsupportedOperationException("FilterBuilder is nor an AndFB nor an OrFB, cannot continue.");
        }
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return ISO8601_UTC.get().format((Date)value);
        }
        return value.toString();
    }
}

