/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.infrastructure.database;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.PropertyMapper;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceImporter;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.infrastructure.database.DataSourceConfiguration;

@Mixins(value={Mixin.class})
public interface DataSourceService
extends ServiceImporter,
Activatable,
ServiceComposite {
    public DataSourceConfiguration getConfiguration(String var1) throws InstantiationException;

    public static abstract class Mixin
    implements DataSourceService,
    Activatable,
    ServiceImporter {
        @Structure
        Module module;
        Map<String, ComboPooledDataSource> pools = new HashMap<String, ComboPooledDataSource>();
        Map<String, DataSourceConfiguration> configs = new HashMap<String, DataSourceConfiguration>();
        Logger logger = LoggerFactory.getLogger(DataSourceService.class);

        public void activate() throws Exception {
            for (DataSourceConfiguration dataSourceConfiguration : this.configs.values()) {
                this.module.unitOfWorkFactory().getUnitOfWork((EntityComposite)dataSourceConfiguration).discard();
            }
            for (Map.Entry entry : this.pools.entrySet()) {
                this.configurePool((ComboPooledDataSource)entry.getValue(), (String)entry.getKey());
            }
        }

        public void passivate() throws Exception {
            for (ComboPooledDataSource pool : this.pools.values()) {
                pool.resetPoolManager();
            }
        }

        public synchronized Object importService(ImportedServiceDescriptor importedServiceDescriptor) throws ServiceImporterException {
            ComboPooledDataSource pool = this.pools.get(importedServiceDescriptor.identity());
            if (pool == null) {
                pool = new ComboPooledDataSource();
                this.configurePool(pool, importedServiceDescriptor.identity());
                this.pools.put(importedServiceDescriptor.identity(), pool);
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(null);
                try {
                    pool.getConnection().close();
                    this.logger.info("Database for DataSource is up!");
                }
                catch (SQLException e) {
                    this.logger.warn("Database for DataSource " + importedServiceDescriptor.identity() + " is not currently available");
                    throw new ServiceImporterException("Database for DataSource " + importedServiceDescriptor.identity() + " is not currently available", (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            return pool;
        }

        private void configurePool(ComboPooledDataSource pool, String identity) {
            try {
                Properties poolProperties;
                DataSourceConfiguration config = this.getConfiguration(identity);
                if (((Boolean)config.enabled().get()).booleanValue()) {
                    Class.forName((String)config.driver().get());
                    pool.setDriverClass((String)config.driver().get());
                    pool.setJdbcUrl((String)config.url().get());
                    String props = (String)config.properties().get();
                    String[] properties = props.split(",");
                    poolProperties = new Properties();
                    for (String property : properties) {
                        if (property.trim().length() <= 0) continue;
                        String[] keyvalue = property.trim().split("=");
                        poolProperties.setProperty(keyvalue[0], keyvalue[1]);
                    }
                } else {
                    throw new ServiceImporterException("DataSource not enabled");
                }
                pool.setProperties(poolProperties);
                pool.setUser((String)config.username().get());
                pool.setPassword((String)config.password().get());
                pool.setMaxConnectionAge(3600);
                this.logger.info("Starting up DataSource '" + identity + "' for:{}", (Object)(pool.getUser() + "@" + pool.getJdbcUrl()));
            }
            catch (Exception e) {
                throw new ServiceImporterException((Throwable)e);
            }
        }

        @Override
        public synchronized DataSourceConfiguration getConfiguration(String identity) throws InstantiationException {
            DataSourceConfiguration config = this.configs.get(identity);
            if (config == null) {
                UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork(UsecaseBuilder.newUsecase((String)"Create DataSource pool configuration"));
                try {
                    config = (DataSourceConfiguration)uow.get(DataSourceConfiguration.class, identity);
                }
                catch (NoSuchEntityException e) {
                    EntityBuilder configBuilder = uow.newEntityBuilder(DataSourceConfiguration.class, identity);
                    String s = identity + ".properties";
                    InputStream asStream = DataSourceConfiguration.class.getClassLoader().getResourceAsStream(s);
                    if (asStream != null) {
                        try {
                            PropertyMapper.map((InputStream)asStream, (Composite)((Composite)configBuilder.instance()));
                        }
                        catch (IOException e1) {
                            uow.discard();
                            InstantiationException exception = new InstantiationException("Could not read underlying Properties file.");
                            exception.initCause(e1);
                            throw exception;
                        }
                    }
                    config = (DataSourceConfiguration)configBuilder.newInstance();
                    try {
                        uow.complete();
                        uow = this.module.unitOfWorkFactory().newUnitOfWork(UsecaseBuilder.newUsecase((String)"Create DataSource pool configuration"));
                        config = (DataSourceConfiguration)uow.get(DataSourceConfiguration.class, identity);
                    }
                    catch (UnitOfWorkCompletionException e2) {
                        InstantiationException exception = new InstantiationException("Could not save configuration in JavaPreferences.");
                        exception.initCause(e2);
                        throw exception;
                    }
                }
                this.configs.put(identity, config);
            }
            return config;
        }

        public boolean isActive(Object instance) {
            return this.pools.containsValue(instance);
        }

        public boolean isAvailable(Object instance) {
            return this.pools.containsValue(instance);
        }
    }
}

