/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.infrastructure.configuration;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.property.Property;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Application;
import org.qi4j.spi.service.ServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
public interface FileConfiguration
extends ServiceComposite,
Activatable {
    public OS os();

    public File user();

    public File configurationDirectory();

    public File dataDirectory();

    public File temporaryDirectory();

    public File cacheDirectory();

    public File logDirectory();

    public static abstract class Mixin
    implements FileConfiguration,
    Activatable {
        final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        @This
        Data data;
        @Uses
        ServiceDescriptor descriptor;
        @Structure
        Application app;

        public void activate() throws Exception {
            OS os = this.detectOS();
            this.data.os().set((Object)os);
            this.logger.info("Operating system:" + os.name());
            String user = System.getenv("USERPROFILE");
            if (user == null) {
                user = System.getProperty("user.home");
            }
            this.data.user().set((Object)new File(user));
            ResourceBundle bundle = ResourceBundle.getBundle(FileConfiguration.class.getName(), new Locale(os.name()));
            String application = System.getProperty("application", this.app.name());
            if (!this.app.mode().equals((Object)Application.Mode.production)) {
                application = application + "-" + this.app.mode().name();
            }
            this.data.application().set((Object)application);
            String temp = System.getProperty("java.io.tmpdir");
            Object[] args = new String[]{application, user, os.name(), temp};
            this.data.configuration().set((Object)new File(MessageFormat.format(bundle.getString("configuration"), args)));
            this.data.data().set((Object)new File(MessageFormat.format(bundle.getString("data"), args)));
            this.data.temporary().set((Object)new File(MessageFormat.format(bundle.getString("temporary"), args)));
            this.data.cache().set((Object)new File(MessageFormat.format(bundle.getString("cache"), args)));
            this.data.log().set((Object)new File(MessageFormat.format(bundle.getString("log"), args)));
            this.autoCreateDirectories();
            this.testCleanup();
        }

        public void passivate() throws Exception {
            this.testCleanup();
        }

        @Override
        public OS os() {
            return (OS)((Object)this.data.os().get());
        }

        @Override
        public File user() {
            return (File)this.data.user().get();
        }

        @Override
        public File configurationDirectory() {
            return (File)this.data.configuration().get();
        }

        @Override
        public File dataDirectory() {
            return (File)this.data.data().get();
        }

        @Override
        public File temporaryDirectory() {
            return (File)this.data.temporary().get();
        }

        @Override
        public File cacheDirectory() {
            return (File)this.data.cache().get();
        }

        @Override
        public File logDirectory() {
            return (File)this.data.log().get();
        }

        private void testCleanup() {
            if (this.app.mode().equals((Object)Application.Mode.test) || this.app.mode().equals((Object)Application.Mode.development)) {
                this.delete(this.configurationDirectory());
                this.delete(this.dataDirectory());
                this.delete(this.temporaryDirectory());
                this.delete(this.cacheDirectory());
                this.delete(this.logDirectory());
            }
        }

        private boolean delete(File file) {
            if (!file.exists()) {
                return true;
            }
            if (file.isFile()) {
                return file.delete();
            }
            for (File childFile : file.listFiles()) {
                if (this.delete(childFile)) continue;
                return false;
            }
            return file.delete();
        }

        private OS detectOS() {
            String osName = System.getProperty("os.name").toLowerCase();
            OS os = osName.indexOf("win") != -1 ? OS.windows : (osName.indexOf("mac") != -1 ? OS.mac : OS.unix);
            return os;
        }

        private void autoCreateDirectories() {
            if (!this.configurationDirectory().exists() && !this.configurationDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create configuration directory(" + this.configurationDirectory() + ")");
            }
            if (!this.dataDirectory().exists() && !this.dataDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create data directory(" + this.dataDirectory() + ")");
            }
            if (!this.temporaryDirectory().exists() && !this.temporaryDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create temporary directory(" + this.temporaryDirectory() + ")");
            }
            if (!this.cacheDirectory().exists() && !this.cacheDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create cache directory(" + this.cacheDirectory() + ")");
            }
            if (!this.logDirectory().exists() && !this.logDirectory().mkdirs()) {
                throw new IllegalStateException("Could not create log directory(" + this.logDirectory() + ")");
            }
        }
    }

    public static interface Data {
        public Property<OS> os();

        public Property<String> application();

        public Property<File> user();

        public Property<File> configuration();

        public Property<File> data();

        public Property<File> temporary();

        public Property<File> cache();

        public Property<File> log();
    }

    public static enum OS {
        windows,
        unix,
        mac;

    }
}

