/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.value.table.gdq;

import se.streamsource.dci.value.table.gdq.GdqTokenType;

class GdqTokenizer {
    String s;
    int nextTokenPosition;
    GdqTokenType currentTokenType;
    String currentTokenStringValue;

    public GdqTokenizer(String s) {
        this.s = s;
        this.nextTokenPosition = 0;
        this.consumeToken();
    }

    GdqTokenType tokenType() {
        return this.currentTokenType;
    }

    String tokenStringValue() {
        return this.currentTokenStringValue;
    }

    void consumeToken() {
        this.currentTokenType = null;
        this.currentTokenStringValue = null;
        this.skipWhite();
        if (this.nextTokenPosition >= this.s.length()) {
            return;
        }
        if (GdqTokenizer.isDelimiter(this.s.charAt(this.nextTokenPosition))) {
            this.currentTokenStringValue = this.s.substring(this.nextTokenPosition, this.nextTokenPosition + 1);
            this.currentTokenType = GdqTokenType.forStringValue(this.currentTokenStringValue);
            ++this.nextTokenPosition;
        } else {
            int firstNonWord = this.nextTokenPosition;
            while (firstNonWord < this.s.length() && !GdqTokenizer.isDelimiter(this.s.charAt(firstNonWord)) && !Character.isWhitespace(this.s.charAt(firstNonWord))) {
                if (this.s.charAt(firstNonWord) == '\"') {
                    firstNonWord = this.s.indexOf(34, firstNonWord + 1) + 1;
                    continue;
                }
                ++firstNonWord;
            }
            this.currentTokenStringValue = this.s.substring(this.nextTokenPosition, firstNonWord);
            this.currentTokenType = GdqTokenType.forStringValue(this.currentTokenStringValue);
            this.nextTokenPosition = firstNonWord;
        }
    }

    private static boolean isDelimiter(char c) {
        return ",".indexOf(c) != -1;
    }

    private void skipWhite() {
        while (this.nextTokenPosition < this.s.length() && Character.isWhitespace(this.s.charAt(this.nextTokenPosition))) {
            ++this.nextTokenPosition;
        }
    }

    public boolean hasToken() {
        return this.currentTokenType != null;
    }

    public boolean hasToken(GdqTokenType type) {
        return this.currentTokenType == type;
    }
}

