/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.value.table.gdq;

import java.util.ArrayList;
import java.util.List;
import se.streamsource.dci.value.table.gdq.GdQuery;
import se.streamsource.dci.value.table.gdq.GdQueryParseException;
import se.streamsource.dci.value.table.gdq.GdqTokenType;
import se.streamsource.dci.value.table.gdq.GdqTokenizer;
import se.streamsource.dci.value.table.gdq.OrderByDirection;
import se.streamsource.dci.value.table.gdq.OrderByElement;

public class GdQueryParser {
    public static GdQuery parse(String s) {
        GdqTokenizer tokenizer = new GdqTokenizer(s);
        GdQuery result = new GdQuery();
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_SELECT)) {
            result.select = GdQueryParser.parseSelectClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_WHERE)) {
            result.where = GdQueryParser.parseMultiWordClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_ORDER)) {
            result.orderBy = GdQueryParser.parseOrderByClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_LIMIT)) {
            result.limit = GdQueryParser.parseIntegerClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_OFFSET)) {
            result.offset = GdQueryParser.parseIntegerClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_OPTIONS)) {
            result.options = GdQueryParser.parseMultiWordClause(tokenizer);
        }
        if (tokenizer.hasToken(GdqTokenType.KEYWORD_GROUP) || tokenizer.hasToken(GdqTokenType.KEYWORD_PIVOT) || tokenizer.hasToken(GdqTokenType.KEYWORD_FORMAT) || tokenizer.hasToken(GdqTokenType.KEYWORD_LABEL)) {
            throw new GdQueryParseException("Unsupported query clause: " + tokenizer.tokenStringValue());
        }
        if (tokenizer.hasToken()) {
            throw new GdQueryParseException("Unexpected token: " + tokenizer.tokenStringValue());
        }
        return result;
    }

    private static List<String> parseSelectClause(GdqTokenizer tokenizer) {
        GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.KEYWORD_SELECT, "select");
        ArrayList<String> result = new ArrayList<String>();
        result.add(GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.WORD, "column name in select clause"));
        while (tokenizer.hasToken(GdqTokenType.COMMA)) {
            tokenizer.consumeToken();
            result.add(GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.WORD, "column name in select clause"));
        }
        return result;
    }

    private static String parseMultiWordClause(GdqTokenizer tokenizer) {
        tokenizer.consumeToken();
        StringBuilder result = new StringBuilder();
        while (tokenizer.hasToken(GdqTokenType.WORD)) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(tokenizer.tokenStringValue());
            tokenizer.consumeToken();
        }
        return result.toString();
    }

    private static List<OrderByElement> parseOrderByClause(GdqTokenizer tokenizer) {
        GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.KEYWORD_ORDER, "order");
        GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.KEYWORD_BY, "by");
        ArrayList<OrderByElement> result = new ArrayList<OrderByElement>();
        result.add(GdQueryParser.parseOrderByElement(tokenizer));
        while (tokenizer.hasToken(GdqTokenType.COMMA)) {
            tokenizer.consumeToken();
            result.add(GdQueryParser.parseOrderByElement(tokenizer));
        }
        return result;
    }

    private static OrderByElement parseOrderByElement(GdqTokenizer tokenizer) {
        String name = GdQueryParser.consumeExpectedToken(tokenizer, GdqTokenType.WORD, "name in order by clause");
        OrderByDirection direction = OrderByDirection.UNDEFINED;
        if (tokenizer.hasToken() && tokenizer.tokenType() == GdqTokenType.WORD) {
            String directionString = tokenizer.tokenStringValue();
            if ("asc".equals(directionString)) {
                direction = OrderByDirection.ASCENDING;
            } else if ("desc".equals(directionString)) {
                direction = OrderByDirection.DESCENDING;
            } else {
                throw new GdQueryParseException("Invalid order by direction: " + directionString);
            }
            tokenizer.consumeToken();
        }
        return new OrderByElement(name, direction);
    }

    private static Integer parseIntegerClause(GdqTokenizer tokenizer) {
        String initialToken = tokenizer.tokenStringValue();
        tokenizer.consumeToken();
        if (tokenizer.hasToken(GdqTokenType.WORD)) {
            try {
                String s = tokenizer.tokenStringValue();
                tokenizer.consumeToken();
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new GdQueryParseException("Expected integer in " + initialToken + " clause");
    }

    private static String consumeExpectedToken(GdqTokenizer tokenizer, GdqTokenType expectedTokenType, String description) {
        if (tokenizer.tokenType() != expectedTokenType) {
            throw new GdQueryParseException("Expected " + description + ", but found " + tokenizer.tokenStringValue());
        }
        String value = tokenizer.tokenStringValue();
        tokenizer.consumeToken();
        return value;
    }
}

