/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.value.table;

import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.util.Function;
import org.qi4j.api.value.ValueBuilderFactory;
import se.streamsource.dci.value.table.TableBuilder;
import se.streamsource.dci.value.table.TableQuery;

public class TableBuilderFactory {
    private ValueBuilderFactory vbf;
    private Map<String, Column> columns = new LinkedHashMap<String, Column>();

    public TableBuilderFactory(ValueBuilderFactory vbf) {
        this.vbf = vbf;
    }

    public TableBuilderFactory column(String id, String label, String type, Function<?, Object> valueFunction, Function<?, String> formattedFunction) {
        this.columns.put(id, new Column(id, label, type, valueFunction, formattedFunction));
        return this;
    }

    public TableBuilderFactory column(String id, String label, String type, Function<?, Object> valueFunction) {
        this.columns.put(id, new Column(id, label, type, valueFunction, null));
        return this;
    }

    public TableBuilder newInstance(TableQuery tableQuery) {
        return new TableBuilder(this.vbf, this.columns, tableQuery);
    }

    class Column {
        private String id;
        private String label;
        private String type;
        private Function<?, Object> valueFunction;
        private Function<?, String> formattedFunction;

        private Column(String id, String label, String type, Function<?, Object> valueFunction, Function<?, String> formattedFunction) {
            this.id = id;
            this.label = label;
            this.type = type;
            this.valueFunction = valueFunction;
            this.formattedFunction = formattedFunction;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public Function<?, Object> getValueFunction() {
            return this.valueFunction;
        }

        public Function<?, String> getFormattedFunction() {
            return this.formattedFunction;
        }
    }
}

