/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.value.table;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.Function;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.value.table.CellValue;
import se.streamsource.dci.value.table.ColumnValue;
import se.streamsource.dci.value.table.RowValue;
import se.streamsource.dci.value.table.TableBuilderFactory;
import se.streamsource.dci.value.table.TableQuery;
import se.streamsource.dci.value.table.TableValue;
import se.streamsource.dci.value.table.gdq.OrderByDirection;

public class TableBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableBuilder.class);
    protected ValueBuilderFactory vbf;
    private Map<String, TableBuilderFactory.Column> columns;
    private TableQuery tableQuery;
    protected ValueBuilder<TableValue> tableBuilder;
    protected ValueBuilder<RowValue> rowBuilder;

    public TableBuilder(ValueBuilderFactory vbf) {
        this.vbf = vbf;
        this.tableBuilder = vbf.newValueBuilder(TableValue.class);
    }

    public TableBuilder(ValueBuilderFactory vbf, Map<String, TableBuilderFactory.Column> columns, TableQuery tableQuery) {
        this.vbf = vbf;
        this.columns = columns;
        this.tableQuery = tableQuery;
        this.tableBuilder = vbf.newValueBuilder(TableValue.class);
        if (tableQuery.select().size() == 1 && "*".equals(tableQuery.select().get(0))) {
            for (TableBuilderFactory.Column column : columns.values()) {
                this.column(column.getId(), column.getLabel(), column.getType());
            }
        } else {
            for (String columnName : tableQuery.select()) {
                TableBuilderFactory.Column column = columns.get(columnName.trim());
                if (column == null) continue;
                this.column(column.getId(), column.getLabel(), column.getType());
            }
        }
    }

    public TableBuilder column(String id, String label, String type) {
        ValueBuilder builder = this.vbf.newValueBuilder(ColumnValue.class);
        ((ColumnValue)builder.prototype()).id().set((Object)id);
        ((ColumnValue)builder.prototype()).label().set((Object)label);
        ((ColumnValue)builder.prototype()).columnType().set((Object)type);
        ((List)((TableValue)this.tableBuilder.prototype()).cols().get()).add(builder.newInstance());
        return this;
    }

    public TableBuilder rows(Iterable<?> rowObjects) {
        boolean no_format = false;
        boolean no_values = false;
        if (this.tableQuery != null && this.tableQuery.options() != null) {
            if (this.tableQuery.options().contains("no_format")) {
                no_format = true;
            }
            if (this.tableQuery != null && this.tableQuery.options().contains("no_values")) {
                no_values = true;
            }
        }
        for (Object rowObject : rowObjects) {
            if (rowObject == null) {
                LOGGER.warn("Encountered null object while building row.");
                continue;
            }
            this.row();
            for (ColumnValue columnValue : (List)((TableValue)this.tableBuilder.prototype()).cols().get()) {
                Object v = null;
                String f = null;
                Function<?, Object> valueFunction = this.columns.get(columnValue.id().get()).getValueFunction();
                if (!no_values && valueFunction != null) {
                    v = valueFunction.map(rowObject);
                }
                Function<?, String> formattedFunction = this.columns.get(columnValue.id().get()).getFormattedFunction();
                if (!no_format && formattedFunction != null) {
                    f = (String)formattedFunction.map(rowObject);
                } else if (v != null) {
                    f = ((String)columnValue.columnType().get()).equals("datetime") ? DateFunctions.toUtcString((Date)((Date)v)) : (((String)columnValue.columnType().get()).equals("date") ? new SimpleDateFormat("yyyy-MM-dd").format((Date)v) : (((String)columnValue.columnType().get()).equals("timeofday") ? new SimpleDateFormat("HH:mm:ss").format((Date)v) : v.toString()));
                }
                this.cell(v, f);
            }
            this.endRow();
        }
        return this;
    }

    public TableBuilder row() {
        if (this.rowBuilder != null) {
            this.endRow();
        }
        this.rowBuilder = this.vbf.newValueBuilder(RowValue.class);
        return this;
    }

    public TableBuilder endRow() {
        ((List)((TableValue)this.tableBuilder.prototype()).rows().get()).add(this.rowBuilder.newInstance());
        this.rowBuilder = null;
        return this;
    }

    public TableBuilder cell(Object v, String f) {
        ValueBuilder cellBuilder = this.vbf.newValueBuilder(CellValue.class);
        ((CellValue)cellBuilder.prototype()).v().set(v);
        ((CellValue)cellBuilder.prototype()).f().set((Object)f);
        ((List)((RowValue)this.rowBuilder.prototype()).c().get()).add(cellBuilder.newInstance());
        return this;
    }

    public TableBuilder orderBy() {
        if (this.tableQuery.orderBy() != null && this.tableQuery.orderBy().size() == 1) {
            String orderByName = this.tableQuery.orderBy().get((int)0).name;
            boolean descending = this.tableQuery.orderBy().get((int)0).direction == OrderByDirection.DESCENDING;
            int sortIndex = -1;
            List columnValues = (List)((TableValue)this.tableBuilder.prototype()).cols().get();
            for (int i = 0; i < columnValues.size(); ++i) {
                ColumnValue columnValue = (ColumnValue)columnValues.get(i);
                if (!((String)columnValue.id().get()).equals(orderByName)) continue;
                sortIndex = i;
                break;
            }
            if (sortIndex != -1) {
                final int idx = sortIndex;
                Comparator<RowValue> comparator = new Comparator<RowValue>(){

                    @Override
                    public int compare(RowValue o1, RowValue o2) {
                        Object o = ((CellValue)((List)o1.c().get()).get(idx)).v().get();
                        if (o != null && o instanceof Comparable) {
                            Comparable c1 = (Comparable)o;
                            Comparable c2 = (Comparable)((CellValue)((List)o2.c().get()).get(idx)).v().get();
                            return c1.compareTo(c2);
                        }
                        String f1 = (String)((CellValue)((List)o1.c().get()).get(idx)).f().get();
                        String f2 = (String)((CellValue)((List)o2.c().get()).get(idx)).f().get();
                        return f1.compareTo(f2);
                    }
                };
                if (descending) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Collections.sort((List)((TableValue)this.tableBuilder.prototype()).rows().get(), comparator);
            }
        }
        return this;
    }

    public TableBuilder paging() {
        int start = 0;
        int end = ((List)((TableValue)this.tableBuilder.prototype()).rows().get()).size();
        if (this.tableQuery.offset() != null) {
            start = this.tableQuery.offset();
        }
        if (this.tableQuery.limit() != null) {
            end = Math.min(end, start + this.tableQuery.limit());
        }
        if (start != 0 || end != ((List)((TableValue)this.tableBuilder.prototype()).rows().get()).size()) {
            ((TableValue)this.tableBuilder.prototype()).rows().set(((List)((TableValue)this.tableBuilder.prototype()).rows().get()).subList(start, end));
        }
        return this;
    }

    public TableValue newTable() {
        if (this.rowBuilder != null) {
            this.endRow();
        }
        return (TableValue)this.tableBuilder.newInstance();
    }

    public void abortRow() {
        this.rowBuilder = null;
    }
}

