/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.value.link;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.qi4j.api.common.Optional;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.dci.value.link.TitledLinkValue;

public class LinksBuilder<T extends LinksBuilder> {
    protected ValueBuilder<? extends LinksValue> linksBuilder;
    protected ValueBuilder<LinkValue> linkBuilder;
    protected ValueBuilder<TitledLinkValue> titledLinkBuilder;
    protected ValueBuilderFactory vbf;
    private String path;
    private String rel;
    private String classes;
    private String command;

    public LinksBuilder(ValueBuilderFactory vbf) {
        this.vbf = vbf;
        this.linksBuilder = vbf.newValueBuilder(LinksValue.class);
        this.linkBuilder = vbf.newValueBuilder(LinkValue.class);
    }

    public T path(@Optional String subPath) {
        this.path = subPath;
        return (T)this;
    }

    public T rel(String rel) {
        this.rel = rel;
        return (T)this;
    }

    public T classes(String classes) {
        this.classes = classes;
        return (T)this;
    }

    public T command(String commandName) {
        this.command = commandName;
        this.rel = commandName;
        return (T)this;
    }

    public T addLink(LinkValue linkValue) {
        ((List)((LinksValue)this.linksBuilder.prototype()).links().get()).add(linkValue);
        return (T)this;
    }

    public T addLink(String description, String id) {
        try {
            ((LinkValue)this.linkBuilder.prototype()).text().set((Object)description);
            ((LinkValue)this.linkBuilder.prototype()).id().set((Object)id);
            if (this.command != null) {
                ((LinkValue)this.linkBuilder.prototype()).href().set((Object)(this.command + "?entity=" + id));
            } else {
                ((LinkValue)this.linkBuilder.prototype()).href().set((Object)((this.path == null ? "" : this.path + "/") + URLEncoder.encode(id, "UTF-8") + "/"));
            }
            ((LinkValue)this.linkBuilder.prototype()).rel().set((Object)this.rel);
            ((LinkValue)this.linkBuilder.prototype()).classes().set((Object)this.classes);
            this.addLink((LinkValue)this.linkBuilder.newInstance());
            return (T)this;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return (T)this;
        }
    }

    public T addLink(String description, String id, String rel, String href, String classes) {
        ((LinkValue)this.linkBuilder.prototype()).text().set((Object)description);
        ((LinkValue)this.linkBuilder.prototype()).id().set((Object)id);
        ((LinkValue)this.linkBuilder.prototype()).rel().set((Object)rel);
        ((LinkValue)this.linkBuilder.prototype()).href().set((Object)href);
        ((LinkValue)this.linkBuilder.prototype()).classes().set((Object)classes);
        this.addLink((LinkValue)this.linkBuilder.newInstance());
        return (T)this;
    }

    public T addLink(String description, EntityReference ref, String title, String classes) {
        if (this.titledLinkBuilder == null) {
            this.titledLinkBuilder = this.vbf.newValueBuilder(TitledLinkValue.class);
        }
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).text().set((Object)description);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).id().set((Object)ref.identity());
        if (this.command != null) {
            ((TitledLinkValue)this.titledLinkBuilder.prototype()).href().set((Object)(this.command + "?entity=" + ref.identity()));
        } else {
            ((TitledLinkValue)this.titledLinkBuilder.prototype()).href().set((Object)((this.path == null ? "" : this.path + "/") + ref.identity() + "/"));
        }
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).rel().set((Object)this.rel);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).title().set((Object)title);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).classes().set((Object)classes);
        ((List)((LinksValue)this.linksBuilder.prototype()).links().get()).add(this.titledLinkBuilder.newInstance());
        return (T)this;
    }

    public T addLink(String description, String id, String rel, String href, String classes, String title) {
        if (this.titledLinkBuilder == null) {
            this.titledLinkBuilder = this.vbf.newValueBuilder(TitledLinkValue.class);
        }
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).text().set((Object)description);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).id().set((Object)id);
        if (this.command != null) {
            ((TitledLinkValue)this.titledLinkBuilder.prototype()).href().set((Object)(this.command + "?entity=" + id));
        } else {
            ((TitledLinkValue)this.titledLinkBuilder.prototype()).href().set((Object)((this.path == null ? "" : this.path + "/") + href));
        }
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).rel().set((Object)rel);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).title().set((Object)title);
        ((TitledLinkValue)this.titledLinkBuilder.prototype()).classes().set((Object)classes);
        ((List)((LinksValue)this.linksBuilder.prototype()).links().get()).add(this.titledLinkBuilder.newInstance());
        return (T)this;
    }

    public LinksValue newLinks() {
        return (LinksValue)this.linksBuilder.newInstance();
    }

    public boolean contains(LinkValue link) {
        return ((List)((LinksValue)this.linksBuilder.prototype()).links().get()).contains(link);
    }

    public void addLinkBefore(LinkValue existingLink, LinkValue newLink) {
        List linkValues = (List)((LinksValue)this.linksBuilder.prototype()).links().get();
        linkValues.add(linkValues.indexOf(existingLink), newLink);
    }
}

