/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.sitemesh;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.routing.Filter;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import se.streamsource.dci.restlet.server.sitemesh.RestletContext;

public class SiteMeshRestletFilter
extends Filter {
    private ContentProcessor contentProcessor;
    private DecoratorSelector<RestletContext> decoratorSelector;

    public SiteMeshRestletFilter(Context context, Restlet next, ContentProcessor contentProcessor, DecoratorSelector<RestletContext> decoratorSelector) {
        super(context, next);
        this.contentProcessor = contentProcessor;
        this.decoratorSelector = decoratorSelector;
    }

    protected int doHandle(Request request, Response response) {
        int result = super.doHandle(request, response);
        RestletContext context = new RestletContext(this.getContext(), request, this.contentProcessor);
        if (!response.getStatus().isSuccess() || !response.getEntity().getMediaType().equals((Object)MediaType.TEXT_HTML)) {
            return result;
        }
        String rep = response.getEntityAsText();
        CharBuffer buffer = CharBuffer.wrap(rep);
        try {
            String[] decoratorPaths;
            Content content = this.contentProcessor.build(buffer, (SiteMeshContext)context);
            if (content == null) {
                return result;
            }
            for (String decoratorPath : decoratorPaths = this.decoratorSelector.selectDecoratorPaths(content, (SiteMeshContext)context)) {
                content = context.decorate(decoratorPath, content);
            }
            if (content == null) {
                return result;
            }
            final Content finalContent = content;
            response.setEntity((Representation)new WriterRepresentation(response.getEntity().getMediaType()){

                public void write(Writer writer) throws IOException {
                    finalContent.getData().writeValueTo((Appendable)writer);
                }
            });
        }
        catch (IOException e) {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        return result;
    }
}

