/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.spi.property.PropertyDescriptor;
import org.qi4j.spi.value.ValueDescriptor;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;

public class ValueDescriptorResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    private Template formHtmlTemplate;

    public ValueDescriptorResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.formHtmlTemplate = velocity.getTemplate("rest/template/form.htm");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof ValueDescriptor) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                JSONObject json = new JSONObject();
                ValueDescriptor vd = (ValueDescriptor)result;
                try {
                    for (PropertyDescriptor propertyDescriptor : vd.state().properties()) {
                        Object o = propertyDescriptor.initialValue();
                        if (o == null) {
                            json.put(propertyDescriptor.qualifiedName().name(), JSONObject.NULL);
                            continue;
                        }
                        json.put(propertyDescriptor.qualifiedName().name(), (Object)o.toString());
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", result);
                        ValueDescriptorResponseWriter.this.formHtmlTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

