/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.value.Value;
import org.qi4j.api.value.ValueComposite;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;
import se.streamsource.dci.restlet.server.velocity.ValueCompositeContext;

public class ValueCompositeResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    private Template valueHtmlTemplate;
    private final VelocityEngine velocity;

    public ValueCompositeResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.velocity = velocity;
        this.valueHtmlTemplate = velocity.getTemplate("rest/template/value.htm");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof Value) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                StringRepresentation representation = new StringRepresentation((CharSequence)((Value)result).toJSON(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                Template template;
                try {
                    template = this.velocity.getTemplate("rest/template/" + result.getClass().getInterfaces()[0].getSimpleName() + ".htm");
                }
                catch (Exception e) {
                    template = this.valueHtmlTemplate;
                }
                final Template finalTemplate = template;
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", (Object)new ValueCompositeContext((ValueComposite)result));
                        finalTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

