/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.json.JSONException;
import org.json.JSONWriter;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.value.ValueComposite;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;
import se.streamsource.dci.restlet.server.velocity.ValueCompositeContext;
import se.streamsource.dci.value.table.CellValue;
import se.streamsource.dci.value.table.ColumnValue;
import se.streamsource.dci.value.table.RowValue;
import se.streamsource.dci.value.table.TableValue;

public class TableResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    private Template htmlTemplate;

    public TableResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.htmlTemplate = velocity.getTemplate("rest/template/table.htm");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof TableValue) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                response.setEntity((Representation)new WriterRepresentation(MediaType.APPLICATION_JSON){

                    public void write(Writer writer) throws IOException {
                        try {
                            JSONWriter json = new JSONWriter(writer);
                            TableValue tableValue = (TableValue)result;
                            String tqx = response.getRequest().getResourceRef().getQueryAsForm().getFirstValue("tqx");
                            String reqId = null;
                            if (tqx != null) {
                                String[] params = tqx.split(";");
                                for (String param : params) {
                                    String[] p = param.split(":");
                                    String key = p[0];
                                    String value = p[1];
                                    if (!key.equals("reqId")) continue;
                                    reqId = value;
                                }
                            }
                            json.object().key("version").value((Object)"0.6");
                            if (reqId != null) {
                                json.key("reqId").value(reqId);
                            }
                            json.key("status").value((Object)"ok");
                            json.key("table").object();
                            List columnList = (List)tableValue.cols().get();
                            json.key("cols").array();
                            for (ColumnValue columnValue : columnList) {
                                json.object().key("id").value(columnValue.id().get()).key("label").value(columnValue.label().get()).key("type").value(columnValue.columnType().get()).endObject();
                            }
                            json.endArray();
                            json.key("rows").array();
                            for (RowValue rowValue : (List)tableValue.rows().get()) {
                                json.object();
                                json.key("c").array();
                                int idx = 0;
                                for (CellValue cellValue : (List)rowValue.c().get()) {
                                    json.object();
                                    Object value = cellValue.v().get();
                                    if (((String)((ColumnValue)columnList.get(idx)).columnType().get()).equals("datetime") && value != null) {
                                        value = DateFunctions.toUtcString((Date)((Date)value));
                                    } else if (((String)((ColumnValue)columnList.get(idx)).columnType().get()).equals("date") && value != null) {
                                        value = new SimpleDateFormat("yyyy-MM-dd").format((Date)value);
                                    } else if (((String)((ColumnValue)columnList.get(idx)).columnType().get()).equals("timeofday") && value != null) {
                                        value = new SimpleDateFormat("HH:mm:ss").format((Date)value);
                                    }
                                    if (value != null) {
                                        json.key("v").value(value);
                                    }
                                    if (cellValue.f().get() != null) {
                                        json.key("f").value(cellValue.f().get());
                                    }
                                    json.endObject();
                                    ++idx;
                                }
                                json.endArray();
                                json.endObject();
                            }
                            json.endArray();
                            json.endObject();
                            json.endObject();
                        }
                        catch (JSONException e) {
                            throw new IOException(e);
                        }
                    }
                });
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", (Object)new ValueCompositeContext((ValueComposite)result));
                        TableResponseWriter.this.htmlTemplate.merge((Context)context, writer);
                    }
                };
                rep.setCharacterSet(CharacterSet.UTF_8);
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

