/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.value.ValueDescriptor;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.service.MetadataService;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;
import se.streamsource.dci.restlet.server.velocity.ValueCompositeContext;

public class ResourceTemplateResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_ATOM);
    @Service
    VelocityEngine velocity;
    @Service
    MetadataService metadataService;
    Set<String> skip = new HashSet<String>();

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
        if (type != null) {
            StringBuilder templateBuilder = (StringBuilder)response.getRequest().getAttributes().get("template");
            String templateName = templateBuilder.toString();
            if (result instanceof ValueDescriptor) {
                templateName = templateName + "_form";
            }
            String extension = this.metadataService.getExtension((Metadata)type);
            if (this.skip.contains(templateName = templateName + "." + extension)) {
                return false;
            }
            try {
                final Template template = this.velocity.getTemplate(templateName);
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        Object res = result;
                        if (res instanceof ValueComposite) {
                            res = new ValueCompositeContext((ValueComposite)res);
                        }
                        context.put("result", res);
                        template.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
            catch (Exception e) {
                this.skip.add(templateName);
            }
        }
        return false;
    }
}

