/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueComposite;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;
import se.streamsource.dci.restlet.server.velocity.ValueCompositeContext;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.Links;

public class ResourceResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_ATOM);
    private Template htmlTemplate;

    public ResourceResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.htmlTemplate = velocity.getTemplate("rest/template/resource.htm");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof ResourceValue) {
            MediaType type;
            ResourceValue resourceValue = (ResourceValue)result;
            response.getAllowedMethods().add(Method.GET);
            if (Iterables.matchesAny(Links.withRel("delete"), (Iterable)((Iterable)resourceValue.commands().get()))) {
                response.getAllowedMethods().add(Method.DELETE);
            }
            if (Iterables.matchesAny(Links.withRel("update"), (Iterable)((Iterable)resourceValue.commands().get()))) {
                response.getAllowedMethods().add(Method.PUT);
            }
            if (MediaType.APPLICATION_JSON.equals((Object)(type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType()))) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)resourceValue.toJSON(), MediaType.APPLICATION_JSON));
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", (Object)new ValueCompositeContext((ValueComposite)result));
                        ResourceResponseWriter.this.htmlTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

