/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.value.ValueComposite;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;
import se.streamsource.dci.restlet.server.velocity.ValueCompositeContext;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;

public class LinksResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedLinkMediaTypes = Arrays.asList(MediaType.APPLICATION_JSON);
    private static final List<MediaType> supportedLinksMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_ATOM);
    private Template linksHtmlTemplate;
    private Template linksAtomTemplate;

    public LinksResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.linksHtmlTemplate = velocity.getTemplate("rest/template/links.htm");
        this.linksAtomTemplate = velocity.getTemplate("rest/template/links.atom");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof LinkValue) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedLinkMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)((LinkValue)result).toJSON(), MediaType.APPLICATION_JSON));
                return true;
            }
            response.setStatus(Status.REDIRECTION_TEMPORARY);
            LinkValue link = (LinkValue)result;
            Reference reference = new Reference(response.getRequest().getResourceRef(), (String)link.href().get());
            response.setLocationRef(reference);
            return true;
        }
        if (result instanceof LinksValue) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedLinksMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)((LinksValue)result).toJSON(), MediaType.APPLICATION_JSON));
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", (Object)new ValueCompositeContext((ValueComposite)result));
                        LinksResponseWriter.this.linksHtmlTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
            if (MediaType.APPLICATION_ATOM.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.APPLICATION_ATOM){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", (Object)new ValueCompositeContext((ValueComposite)result));
                        LinksResponseWriter.this.linksAtomTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

