/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;

public class JSONResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);

    @Override
    public boolean write(Object result, Response response) throws ResourceException {
        if (result instanceof JSONObject || result instanceof JSONArray) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            String jsonValue = result instanceof JSONObject ? ((JSONObject)result).toString() : ((JSONArray)result).toString();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                StringRepresentation representation = new StringRepresentation((CharSequence)jsonValue, MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                StringRepresentation representation = new StringRepresentation((CharSequence)jsonValue, MediaType.TEXT_HTML);
                response.setEntity((Representation)representation);
                return true;
            }
        }
        return false;
    }
}

