/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.server.responsewriter.AbstractResponseWriter;

public class FormResponseWriter
extends AbstractResponseWriter {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.TEXT_HTML, MediaType.APPLICATION_JSON);
    private Template formHtmlTemplate;

    public FormResponseWriter(@Service VelocityEngine velocity) throws Exception {
        this.formHtmlTemplate = velocity.getTemplate("rest/template/form.htm");
    }

    @Override
    public boolean write(final Object result, final Response response) throws ResourceException {
        if (result instanceof Form) {
            MediaType type = this.getVariant(response.getRequest(), ENGLISH, supportedMediaTypes).getMediaType();
            if (MediaType.APPLICATION_JSON.equals((Object)type)) {
                JSONObject json = new JSONObject();
                Form form = (Form)result;
                try {
                    for (Parameter parameter : form) {
                        String value = parameter.getValue();
                        if (value == null) {
                            json.put(parameter.getName(), JSONObject.NULL);
                            continue;
                        }
                        json.put(parameter.getName(), (Object)value);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                StringRepresentation representation = new StringRepresentation((CharSequence)json.toString(), MediaType.APPLICATION_JSON);
                response.setEntity((Representation)representation);
                return true;
            }
            if (MediaType.TEXT_HTML.equals((Object)type)) {
                WriterRepresentation rep = new WriterRepresentation(MediaType.TEXT_HTML){

                    public void write(Writer writer) throws IOException {
                        VelocityContext context = new VelocityContext();
                        context.put("request", (Object)response.getRequest());
                        context.put("response", (Object)response);
                        context.put("result", result);
                        FormResponseWriter.this.formHtmlTemplate.merge((Context)context, writer);
                    }
                };
                response.setEntity((Representation)rep);
                return true;
            }
        }
        return false;
    }
}

