/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.requestreader;

import java.lang.reflect.Method;
import java.util.Date;
import org.json.JSONException;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.constraint.Name;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.Property;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.property.PropertyType;
import org.qi4j.spi.structure.ModuleSPI;
import org.qi4j.spi.value.ValueDescriptor;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.restlet.server.RequestReader;

public class DefaultRequestReader
implements RequestReader {
    @Structure
    Qi4jSPI spi;
    @Structure
    ModuleSPI module;

    @Override
    public Object[] readRequest(Request request, Method method) {
        if (request.getMethod().equals((Object)org.restlet.data.Method.GET)) {
            Object[] args = new Object[method.getParameterTypes().length];
            Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
            Form entityAsForm = null;
            Representation representation = Request.getCurrent().getEntity();
            entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) ? new Form(representation) : new Form();
            if (queryAsForm.isEmpty() && entityAsForm.isEmpty()) {
                return null;
            }
            if (args.length == 1) {
                if (ValueComposite.class.isAssignableFrom(method.getParameterTypes()[0])) {
                    Class<?> valueType = method.getParameterTypes()[0];
                    args[0] = this.getValueFromForm(valueType, queryAsForm, entityAsForm);
                    return args;
                }
                if (Form.class.equals(method.getParameterTypes()[0])) {
                    args[0] = queryAsForm.isEmpty() ? entityAsForm : queryAsForm;
                    return args;
                }
                if (Response.class.equals(method.getParameterTypes()[0])) {
                    args[0] = Response.getCurrent();
                    return args;
                }
            }
            this.parseMethodArguments(method, args, queryAsForm, entityAsForm);
            return args;
        }
        Object[] args = new Object[method.getParameterTypes().length];
        Class<?> commandType = method.getParameterTypes()[0];
        if (method.getParameterTypes()[0].equals(Response.class)) {
            return new Object[]{Response.getCurrent()};
        }
        Representation representation = Request.getCurrent().getEntity();
        MediaType type = representation.getMediaType();
        if (type == null) {
            Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm(CharacterSet.UTF_8);
            if (ValueComposite.class.isAssignableFrom(method.getParameterTypes()[0])) {
                args[0] = this.getValueFromForm(commandType, queryAsForm, new Form());
            } else {
                this.parseMethodArguments(method, args, queryAsForm, new Form());
            }
            return args;
        }
        if (method.getParameterTypes()[0].equals(Representation.class)) {
            return new Object[]{representation};
        }
        if (method.getParameterTypes()[0].equals(Form.class)) {
            return new Object[]{new Form(representation)};
        }
        if (ValueComposite.class.isAssignableFrom(method.getParameterTypes()[0])) {
            if (type.equals((Object)MediaType.APPLICATION_JSON)) {
                Object command;
                String json = Request.getCurrent().getEntityAsText();
                if (json == null) {
                    LoggerFactory.getLogger(this.getClass()).error("Restlet bugg http://restlet.tigris.org/issues/show_bug.cgi?id=843 detected. Notify developers!");
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Bug in Tomcat encountered; notify developers!");
                }
                args[0] = command = this.module.valueBuilderFactory().newValueFromJSON(commandType, json);
                return args;
            }
            if (type.equals((Object)MediaType.TEXT_PLAIN)) {
                String text = Request.getCurrent().getEntityAsText();
                if (text == null) {
                    LoggerFactory.getLogger(this.getClass()).error("Restlet bugg http://restlet.tigris.org/issues/show_bug.cgi?id=843 detected. Notify developers!");
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Bug in Tomcat encountered; notify developers!");
                }
                args[0] = text;
                return args;
            }
            if (type.equals((Object)MediaType.APPLICATION_WWW_FORM)) {
                Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
                Form entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) && representation.isAvailable() ? new Form(representation) : new Form();
                Class<?> valueType = method.getParameterTypes()[0];
                args[0] = this.getValueFromForm(valueType, queryAsForm, entityAsForm);
                return args;
            }
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Command has to be in JSON format");
        }
        if (method.getParameterTypes()[0].isInterface() && method.getParameterTypes().length == 1) {
            Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
            Form entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) && representation.isAvailable() ? new Form(representation) : new Form();
            args[0] = this.module.unitOfWorkFactory().currentUnitOfWork().get(method.getParameterTypes()[0], this.getValue("entity", queryAsForm, entityAsForm));
            return args;
        }
        Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
        Form entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) && representation.isAvailable() ? new Form(representation) : new Form();
        this.parseMethodArguments(method, args, queryAsForm, entityAsForm);
        return args;
    }

    private ValueComposite getValueFromForm(Class<? extends ValueComposite> valueType, final Form queryAsForm, final Form entityAsForm) {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(valueType);
        final ValueDescriptor descriptor = this.spi.getValueDescriptor((ValueComposite)builder.prototype());
        builder.withState(new StateHolder(){

            public <T> Property<T> getProperty(QualifiedName name) {
                return null;
            }

            public <T> Property<T> getProperty(Method propertyMethod) {
                return null;
            }

            public <ThrowableType extends Throwable> void visitProperties(StateHolder.StateVisitor<ThrowableType> visitor) throws ThrowableType {
                for (PropertyType propertyType : descriptor.valueType().types()) {
                    Parameter param = queryAsForm.getFirst(propertyType.qualifiedName().name());
                    if (param == null) {
                        param = entityAsForm.getFirst(propertyType.qualifiedName().name());
                    }
                    if (param == null) continue;
                    String value = param.getValue();
                    if (value == null) {
                        value = "";
                    }
                    try {
                        Object valueObject = propertyType.type().fromQueryParameter(value, (Module)DefaultRequestReader.this.module);
                        visitor.visitProperty(propertyType.qualifiedName(), valueObject);
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException("Query parameter has invalid JSON format", e);
                    }
                }
            }
        });
        return (ValueComposite)builder.newInstance();
    }

    private void parseMethodArguments(Method method, Object[] args, Form queryAsForm, Form entityAsForm) {
        int idx = 0;
        for (Object[] objectArray : method.getParameterAnnotations()) {
            Name name = (Name)Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Name.class), (Iterable)Iterables.iterable((Object[])objectArray)));
            if (name == null) {
                throw new IllegalStateException("No @Name annotation found on parameter of method:" + method);
            }
            String argString = this.getValue(name.value(), queryAsForm, entityAsForm);
            Class<?> parameterType = method.getParameterTypes()[idx];
            Object arg = null;
            if (parameterType.equals(String.class)) {
                arg = this.hasParamWithName(name.value(), queryAsForm, entityAsForm) && argString == null ? "" : argString;
            } else if (parameterType.equals(EntityReference.class)) {
                arg = EntityReference.parseEntityReference((String)argString);
            } else if (parameterType.isEnum()) {
                arg = Enum.valueOf(parameterType, argString);
            } else if (Integer.TYPE.isAssignableFrom(parameterType)) {
                arg = Integer.valueOf(argString);
            } else if (Integer.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Integer.valueOf(argString);
                }
            } else if (Long.TYPE.isAssignableFrom(parameterType)) {
                arg = Long.valueOf(argString);
            } else if (Long.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Long.valueOf(argString);
                }
            } else if (Short.TYPE.isAssignableFrom(parameterType)) {
                arg = Short.valueOf(argString);
            } else if (Short.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Short.valueOf(argString);
                }
            } else if (Double.TYPE.isAssignableFrom(parameterType)) {
                arg = Double.valueOf(argString);
            } else if (Double.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Double.valueOf(argString);
                }
            } else if (Float.TYPE.isAssignableFrom(parameterType)) {
                arg = Float.valueOf(argString);
            } else if (Float.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Float.valueOf(argString);
                }
            } else if (Character.TYPE.isAssignableFrom(parameterType)) {
                arg = Character.valueOf(argString.charAt(0));
            } else if (Character.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Character.valueOf(argString.charAt(0));
                }
            } else if (Boolean.TYPE.isAssignableFrom(parameterType)) {
                arg = Boolean.valueOf(argString);
            } else if (Boolean.class.isAssignableFrom(parameterType)) {
                if (argString != null) {
                    arg = Boolean.valueOf(argString);
                }
            } else if (Date.class.isAssignableFrom(parameterType)) {
                arg = DateFunctions.fromString((String)argString);
            } else if (parameterType.isInterface()) {
                arg = this.module.unitOfWorkFactory().currentUnitOfWork().get(parameterType, argString);
            } else {
                throw new IllegalArgumentException("Don't know how to parse parameter " + name.value() + " of type " + parameterType.getName());
            }
            if (arg == null && !Iterables.matchesAny((Specification)Annotations.isType(Optional.class), (Iterable)Iterables.iterable((Object[])objectArray))) {
                throw new IllegalArgumentException("Parameter " + name.value() + " was not set");
            }
            args[idx++] = arg;
        }
    }

    private String getValue(String name, Form queryAsForm, Form entityAsForm) {
        String value = queryAsForm.getFirstValue(name);
        if (value == null) {
            value = entityAsForm.getFirstValue(name);
        }
        return value;
    }

    private boolean hasParamWithName(String name, Form queryAsForm, Form entityAsForm) {
        Parameter param = queryAsForm.getFirst(name);
        if (param == null) {
            param = entityAsForm.getFirst(name);
        }
        return param != null;
    }
}

