/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server.api;

import java.util.Date;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.entity.EntityState;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.resource.ResourceException;

public class ResourceValidity {
    EntityComposite entity;
    private final Qi4jSPI spi;

    public ResourceValidity(EntityComposite entity, Qi4jSPI spi) {
        this.entity = entity;
        this.spi = spi;
    }

    public void updateEntity(UnitOfWork current) {
        try {
            this.entity = (EntityComposite)current.get((Object)this.entity);
        }
        catch (NoSuchEntityException e) {
            this.entity = null;
        }
    }

    public void updateResponse(Response response) {
        if (this.entity != null) {
            EntityState state = this.spi.getEntityState(this.entity);
            Date lastModified = new Date(state.lastModified());
            Tag tag = new Tag(state.identity().identity() + "/" + state.version());
            response.getEntity().setModificationDate(lastModified);
            response.getEntity().setTag(tag);
        }
    }

    public void checkRequest(Request request) throws ResourceException {
        EntityState state;
        Date lastModified;
        Date modificationDate = request.getConditions().getUnmodifiedSince();
        if (modificationDate != null && (lastModified = new Date((state = this.spi.getEntityState(this.entity)).lastModified() / 1000L * 1000L)).after(modificationDate)) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT);
        }
        modificationDate = request.getConditions().getModifiedSince();
        if (modificationDate != null && !(lastModified = new Date((state = this.spi.getEntityState(this.entity)).lastModified() / 1000L * 1000L)).after(modificationDate)) {
            throw new ResourceException(Status.REDIRECTION_NOT_MODIFIED);
        }
    }
}

