/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.InitializationException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Module;
import org.restlet.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.restlet.server.ResponseWriter;

public class ResponseWriterDelegator
implements ResponseWriter {
    List<ResponseWriter> responseWriters = new ArrayList<ResponseWriter>();
    @Structure
    Module module;

    public void init(@Service Iterable<ServiceReference<ResponseWriter>> resultWriters) throws InitializationException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        for (ServiceReference<ResponseWriter> resultWriter : resultWriters) {
            if (resultWriter.identity().equals("responsewriterdelegator")) continue;
            logger.info("Registered result writer:" + resultWriter.identity());
            this.registerResultWriter((ResponseWriter)resultWriter.get());
        }
        ResourceBundle defaultResultWriters = ResourceBundle.getBundle("commandquery");
        String resultWriterClasses = defaultResultWriters.getString("responsewriters");
        logger.info("Using response writers:" + resultWriterClasses);
        for (String className : resultWriterClasses.split(",")) {
            try {
                Class<?> writerClass = this.module.classLoader().loadClass(className.trim());
                ResponseWriter writer = (ResponseWriter)this.module.objectBuilderFactory().newObject(writerClass);
                this.registerResultWriter(writer);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not register response writer " + className, (Throwable)e);
            }
        }
    }

    public void registerResultWriter(ResponseWriter writer) {
        this.responseWriters.add(writer);
    }

    @Override
    public boolean write(Object result, Response response) {
        for (ResponseWriter responseWriter : this.responseWriters) {
            if (!responseWriter.write(result, response)) continue;
            return true;
        }
        return false;
    }
}

