/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.qi4j.api.constraint.ConstraintViolation;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.api.RoleMap;
import se.streamsource.dci.restlet.server.ConstraintViolationMessages;

public class ResourceExceptionHelper {
    public static void handleException(Class clazz, Response response, Throwable ex) {
        while (ex instanceof InvocationTargetException) {
            ex = ex.getCause();
        }
        try {
            throw ex;
        }
        catch (ResourceException e) {
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(e.getStatus());
        }
        catch (ConstraintViolationException e) {
            try {
                ConstraintViolationMessages cvm = new ConstraintViolationMessages();
                String messages = "";
                Locale locale = RoleMap.role(Locale.class);
                for (ConstraintViolation constraintViolation : e.constraintViolations()) {
                    if (!messages.equals("")) {
                        messages = messages + "\n";
                    }
                    messages = messages + cvm.getMessage(constraintViolation, locale);
                }
                response.setEntity((Representation)new StringRepresentation((CharSequence)messages));
                response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
            }
            catch (Exception e1) {
                response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
                response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
            }
        }
        catch (IllegalArgumentException e) {
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger((Class)clazz).warn("Exception thrown during processing", (Throwable)e);
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
        catch (Exception e) {
            String s = e.getMessage();
            if (s == null) {
                s = e.getClass().getSimpleName();
            }
            response.setEntity((Representation)new StringRepresentation((CharSequence)s));
            response.setStatus(Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger((Class)clazz).error("Exception thrown during processing", e);
            response.setEntity((Representation)new StringRepresentation((CharSequence)e.getMessage()));
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }
}

