/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.server;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.TransientBuilder;
import org.qi4j.api.composite.TransientComposite;
import org.qi4j.api.constraint.Name;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.association.ManyAssociation;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.object.ObjectBuilder;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.unitofwork.EntityTypeNotFoundException;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.util.Annotations;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.property.PropertyDescriptor;
import org.qi4j.spi.structure.ModuleSPI;
import org.qi4j.spi.value.ValueDescriptor;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.api.InteractionConstraints;
import se.streamsource.dci.api.RoleMap;
import se.streamsource.dci.api.SkipResourceValidityCheck;
import se.streamsource.dci.restlet.server.CommandQueryRestlet;
import se.streamsource.dci.restlet.server.RequestReaderDelegator;
import se.streamsource.dci.restlet.server.ResourceExceptionHelper;
import se.streamsource.dci.restlet.server.ResponseWriterDelegator;
import se.streamsource.dci.restlet.server.ResultConverter;
import se.streamsource.dci.restlet.server.api.ResourceValidity;
import se.streamsource.dci.restlet.server.api.SubResource;
import se.streamsource.dci.restlet.server.api.SubResources;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;

public class CommandQueryResource
implements Uniform {
    private static final String ARGUMENTS = "arguments";
    private Map<String, Class> interactionClasses = new ConcurrentHashMap<String, Class>();
    private Map<String, Method> resourceMethods = new ConcurrentHashMap<String, Method>();
    private Map<String, Method> contextMethods = new ConcurrentHashMap<String, Method>();
    @Structure
    private Qi4jSPI spi;
    @Structure
    protected ModuleSPI module;
    @Service
    private ResponseWriterDelegator resultWriter;
    @Service
    RequestReaderDelegator requestReader;
    @Service
    private InteractionConstraints constraints;
    @Optional
    @Service
    private ResultConverter converter;
    @Uses
    private CommandQueryRestlet restlet;
    private Class[] contextClasses;

    public CommandQueryResource(Class ... contextClasses) {
        this.contextClasses = contextClasses;
        for (Method method : this.getClass().getMethods()) {
            Method oldMethod;
            if (!CommandQueryResource.class.isAssignableFrom(method.getDeclaringClass()) || CommandQueryResource.class.equals(method.getDeclaringClass()) || (oldMethod = this.resourceMethods.put(method.getName().toLowerCase(), method)) == null) continue;
            throw new IllegalStateException("Two methods in resource " + this.getClass().getName() + " with same name " + oldMethod.getName() + ", which is not allowed");
        }
        for (GenericDeclaration genericDeclaration : contextClasses) {
            for (Method method : ((Class)genericDeclaration).getMethods()) {
                if (method.isSynthetic() || this.interactionClasses.containsKey(method.getName().toLowerCase())) continue;
                this.interactionClasses.put(method.getName().toLowerCase(), (Class)genericDeclaration);
                this.contextMethods.put(method.getName().toLowerCase(), method);
            }
        }
    }

    public final void handle(Request request, Response response) {
        RoleMap roleMap = RoleMap.current();
        if (!this.constraints.isValid(this.getClass(), roleMap, this.module)) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
        }
        RoleMap.setCurrentRoleMap(new RoleMap(roleMap));
        List<String> segments = this.getSegments();
        if (segments.size() > 0) {
            String segment = segments.remove(0);
            if (segments.size() > 0) {
                this.handleSubResource(segment);
            } else {
                this.handleResource(segment);
            }
        }
    }

    protected void setResourceValidity(EntityComposite entity) {
        ResourceValidity validity = new ResourceValidity(entity, this.spi);
        RoleMap.current().set(validity, new Class[0]);
    }

    protected <T> T context(Class<T> contextClass) {
        if (TransientComposite.class.isAssignableFrom(contextClass)) {
            TransientBuilder builder = this.module.transientBuilderFactory().newTransientBuilder(contextClass);
            for (Object rolePlayer : RoleMap.current().getAll(Object.class)) {
                builder.use(new Object[]{rolePlayer});
            }
            return (T)builder.newInstance();
        }
        ObjectBuilder builder = this.module.objectBuilderFactory().newObjectBuilder(contextClass);
        for (Object rolePlayer : RoleMap.current().getAll(Object.class)) {
            builder.use(new Object[]{rolePlayer});
        }
        return (T)builder.newInstance();
    }

    protected void subResource(Class<? extends CommandQueryResource> subResourceClass) {
        this.restlet.subResource(subResourceClass);
    }

    protected void subResourceContexts(Class<?> ... contextClasses) {
        this.restlet.subResourceContexts(contextClasses);
    }

    protected <T> T setRole(Class<T> entityClass, String id, Class ... roleClasses) throws ResourceException {
        try {
            Object composite = this.module.unitOfWorkFactory().currentUnitOfWork().get(entityClass, id);
            RoleMap.current().set(composite, roleClasses);
            return (T)composite;
        }
        catch (EntityTypeNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        catch (NoSuchEntityException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    protected <T> T findManyAssociation(ManyAssociation<T> manyAssociation, String id) throws ResourceException {
        for (Object entity : manyAssociation) {
            if (!entity.toString().equals(id)) continue;
            RoleMap.current().set(entity, new Class[0]);
            return (T)entity;
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
    }

    protected void findList(List<?> list, String indexString) {
        Integer index = Integer.decode(indexString);
        if (index < 0 || index >= list.size()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        RoleMap.current().set(index, Integer.class);
        Object value = list.get(index);
        RoleMap.current().set(value, new Class[0]);
    }

    protected Locale getLocale() {
        Locale locale;
        Request request = Request.getCurrent();
        List preferenceList = request.getClientInfo().getAcceptedLanguages();
        if (preferenceList.isEmpty()) {
            return Locale.getDefault();
        }
        Language language = (Language)((Preference)preferenceList.get(0)).getMetadata();
        String[] localeStr = language.getName().split("-");
        switch (localeStr.length) {
            case 1: {
                locale = new Locale(localeStr[0]);
                break;
            }
            case 2: {
                locale = new Locale(localeStr[0], localeStr[1]);
                break;
            }
            case 3: {
                locale = new Locale(localeStr[0], localeStr[1], localeStr[2]);
                break;
            }
            default: {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    private void handleSubResource(String segment) {
        if (this instanceof SubResources) {
            SubResources subResources = (SubResources)((Object)this);
            try {
                StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
                template.append("resource/");
                subResources.resource(URLDecoder.decode(segment, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                subResources.resource(segment);
            }
        } else {
            try {
                Method method = this.getSubResourceMethod(segment);
                StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
                template.append(segment).append("/");
                method.invoke((Object)this, new Object[0]);
            }
            catch (Throwable e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        }
    }

    private Method getSubResourceMethod(String resourceName) {
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(resourceName) || method.getAnnotation(SubResource.class) == null) continue;
            return method;
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
    }

    private void resource() {
        if (Request.getCurrent().getMethod().equals((Object)org.restlet.data.Method.GET)) {
            RoleMap roleMap = RoleMap.current();
            ArrayList<Method> queries = new ArrayList<Method>();
            ArrayList<Method> commands = new ArrayList<Method>();
            ArrayList<Method> subResources = new ArrayList<Method>();
            for (Class contextClass : this.contextClasses) {
                if (!this.constraints.isValid(contextClass, roleMap, this.module)) continue;
                Iterable methods = Iterables.filter((Specification)new Specification<Method>(){

                    public boolean satisfiedBy(Method method) {
                        return !method.isSynthetic() && !method.getDeclaringClass().isAssignableFrom(TransientComposite.class) && !method.getName().equals("isValid") && !method.getName().equals("bind");
                    }
                }, (Iterable)Iterables.iterable((Object[])contextClass.getMethods()));
                for (Method method : methods) {
                    if (!this.constraints.isValid(method, roleMap, this.module)) continue;
                    if (this.isCommand(method)) {
                        commands.add(method);
                        continue;
                    }
                    queries.add(method);
                }
            }
            if (!SubResources.class.isAssignableFrom(this.getClass())) {
                List<Method> methods = Arrays.asList(this.getClass().getMethods());
                for (Method method : methods) {
                    if (method.getAnnotation(SubResource.class) == null || !this.constraints.isValid(method, roleMap, this.module)) continue;
                    subResources.add(method);
                }
            }
            ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(ResourceValue.class);
            ValueBuilder linkBuilder = this.module.valueBuilderFactory().newValueBuilder(LinkValue.class);
            LinkValue prototype = (LinkValue)linkBuilder.prototype();
            if (queries.size() > 0) {
                List queriesProperty = (List)((ResourceValue)builder.prototype()).queries().get();
                prototype.classes().set((Object)"query");
                for (Method query : queries) {
                    prototype.text().set((Object)this.humanReadable(query.getName()));
                    prototype.href().set((Object)query.getName().toLowerCase());
                    prototype.rel().set((Object)query.getName().toLowerCase());
                    prototype.id().set((Object)query.getName().toLowerCase());
                    queriesProperty.add(linkBuilder.newInstance());
                }
            }
            if (commands.size() > 0) {
                List commandsProperty = (List)((ResourceValue)builder.prototype()).commands().get();
                prototype.classes().set((Object)"command");
                for (Method command : commands) {
                    prototype.text().set((Object)this.humanReadable(command.getName()));
                    prototype.href().set((Object)command.getName().toLowerCase());
                    prototype.rel().set((Object)command.getName().toLowerCase());
                    prototype.id().set((Object)command.getName().toLowerCase());
                    commandsProperty.add(linkBuilder.newInstance());
                }
            }
            if (subResources.size() > 0) {
                List resourcesProperty = (List)((ResourceValue)builder.prototype()).resources().get();
                prototype.classes().set((Object)"resource");
                for (Method subResource : subResources) {
                    prototype.text().set((Object)this.humanReadable(subResource.getName()));
                    prototype.href().set((Object)(subResource.getName().toLowerCase() + "/"));
                    prototype.rel().set((Object)subResource.getName().toLowerCase());
                    prototype.id().set((Object)subResource.getName().toLowerCase());
                    resourcesProperty.add(linkBuilder.newInstance());
                }
            }
            try {
                Object index = this.convert(this.invokeResource(this.getInteractionMethod("index")));
                if (index != null && index instanceof ValueComposite) {
                    ((ResourceValue)builder.prototype()).index().set((Object)((ValueComposite)index));
                }
            }
            catch (Throwable index) {
                // empty catch block
            }
            try {
                this.resultWriter.write(builder.newInstance(), Response.getCurrent());
            }
            catch (Throwable e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        } else {
            Response.getCurrent().setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
    }

    private boolean isCommand(Method method) {
        return method.getReturnType().equals(Void.TYPE) || method.getName().equals("create");
    }

    private String humanReadable(String name) {
        StringBuilder humanReadableString = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (i == 0) {
                humanReadableString.append(Character.toUpperCase(character));
                continue;
            }
            if (Character.isLowerCase(character)) {
                humanReadableString.append(character);
                continue;
            }
            humanReadableString.append(' ').append(Character.toLowerCase(character));
        }
        return humanReadableString.toString();
    }

    private Object createContext(String interactionName) {
        Class contextClass = this.interactionClasses.get(interactionName);
        if (contextClass == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return this.context(contextClass);
    }

    private void result(Object resultValue) throws Exception {
        if (resultValue != null && !this.resultWriter.write(resultValue, Response.getCurrent())) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No result writer for type " + resultValue.getClass().getName());
        }
    }

    private Object invoke(Object target, Method method, Method contextMethod) throws Throwable {
        Object[] arguments;
        block15: {
            if (!this.constraints.isValid(contextMethod.getDeclaringClass(), RoleMap.current(), this.module)) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (!this.constraints.isValid(contextMethod, RoleMap.current(), this.module)) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (this.isCommand(contextMethod)) {
                Object[] arguments2 = this.requestReader.readRequest(Request.getCurrent(), method);
                Request.getCurrent().getAttributes().put(ARGUMENTS, arguments2);
                try {
                    method.invoke(target, arguments2);
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            if (method.getParameterTypes().length > 0) {
                try {
                    arguments = this.requestReader.readRequest(Request.getCurrent(), method);
                    if (arguments == null) {
                        return this.formForMethod(method);
                    }
                    break block15;
                }
                catch (IllegalArgumentException e) {
                    return this.formForMethod(method);
                }
            }
            arguments = new Object[]{};
        }
        try {
            Request.getCurrent().getAttributes().put(ARGUMENTS, arguments);
            return method.invoke(target, arguments);
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Method getInteractionMethod(String methodName) throws ResourceException {
        Method method = this.contextMethods.get(methodName);
        if (method == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return method;
    }

    private List<String> getSegments() {
        return (List)Request.getCurrent().getAttributes().get("segments");
    }

    private void handleResource(String segment) {
        if (segment.equals("") || segment.equals(".")) {
            StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
            template.append("resource");
            this.resource();
        } else {
            StringBuilder template = (StringBuilder)Request.getCurrent().getAttributes().get("template");
            template.append(segment);
            Method contextMethod = null;
            try {
                contextMethod = this.getInteractionMethod(segment);
            }
            catch (ResourceException e) {
                Method resourceMethod = this.resourceMethods.get(segment);
                if (resourceMethod != null && resourceMethod.getAnnotation(SubResource.class) != null) {
                    Response.getCurrent().setStatus(Status.REDIRECTION_FOUND);
                    Response.getCurrent().setLocationRef(new Reference(Request.getCurrent().getResourceRef().toString() + "/").toString());
                    return;
                }
                throw e;
            }
            if (this.isCommand(contextMethod)) {
                this.handleCommand(contextMethod);
            } else {
                this.handleQuery(contextMethod);
            }
        }
    }

    private void handleCommand(Method contextMethod) {
        if (this.shouldShowCommandForm(contextMethod)) {
            Request.getCurrent().setMethod(org.restlet.data.Method.POST);
            try {
                this.result(this.formForMethod(contextMethod));
            }
            catch (Exception e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        } else {
            try {
                ResourceValidity validity = RoleMap.role(ResourceValidity.class);
                validity.checkRequest(Request.getCurrent());
            }
            catch (IllegalArgumentException validity) {
                // empty catch block
            }
            try {
                Object result = this.invokeResource(contextMethod);
                if (result != null) {
                    if (result instanceof Representation) {
                        Response.getCurrent().setEntity((Representation)result);
                    } else {
                        this.result(this.convert(result));
                    }
                }
            }
            catch (Throwable e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        }
    }

    private Object invokeResource(Method contextMethod) throws Throwable {
        Method method = this.resourceMethods.get(contextMethod.getName().toLowerCase());
        if (method != null) {
            return this.invoke(this, method, contextMethod);
        }
        Object context = this.createContext(contextMethod.getName().toLowerCase());
        return this.invoke(context, contextMethod, contextMethod);
    }

    private boolean shouldShowCommandForm(Method contextMethod) {
        if (Request.getCurrent().getMethod().isSafe()) {
            return true;
        }
        if (contextMethod.getParameterTypes().length > 0) {
            return !contextMethod.getParameterTypes()[0].equals(Response.class) && !Request.getCurrent().getEntity().isAvailable() && Request.getCurrent().getEntityAsText() == null && Request.getCurrent().getResourceRef().getQuery() == null;
        }
        return false;
    }

    private void handleQuery(Method contextMethod) {
        if (Request.getCurrent().getMethod().isSafe() && contextMethod.getParameterTypes().length != 0 && Request.getCurrent().getResourceRef().getQuery() == null || !Request.getCurrent().getMethod().isSafe() && contextMethod.getParameterTypes().length != 0 && !Request.getCurrent().getEntity().isAvailable() && Request.getCurrent().getResourceRef().getQuery() == null && !contextMethod.getParameterTypes()[0].equals(Response.class)) {
            try {
                this.result(this.formForMethod(contextMethod));
            }
            catch (Exception e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        } else {
            if (contextMethod.getAnnotation(SkipResourceValidityCheck.class) == null) {
                try {
                    ResourceValidity validity = RoleMap.role(ResourceValidity.class);
                    validity.checkRequest(Request.getCurrent());
                }
                catch (IllegalArgumentException validity) {
                    // empty catch block
                }
            }
            try {
                Object result = this.invokeResource(contextMethod);
                if (result != null) {
                    if (result instanceof Representation) {
                        Response.getCurrent().setEntity((Representation)result);
                    } else {
                        this.result(this.convert(result));
                    }
                }
            }
            catch (IllegalAccessException e) {
                Response.getCurrent().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
            catch (Throwable e) {
                ResourceExceptionHelper.handleException(this.getClass(), Response.getCurrent(), e);
            }
        }
    }

    private Object convert(Object result) {
        if (this.converter != null) {
            result = this.converter.convert(result, Request.getCurrent(), (Object[])Request.getCurrent().getAttributes().get(ARGUMENTS));
        }
        return result;
    }

    private Form formForMethod(Method contextMethod) {
        Form form = new Form();
        Form queryAsForm = Request.getCurrent().getResourceRef().getQueryAsForm();
        Form entityAsForm = null;
        Representation representation = Request.getCurrent().getEntity();
        entityAsForm = representation != null && !EmptyRepresentation.class.isInstance(representation) ? new Form(representation) : new Form();
        Class<?> valueType = contextMethod.getParameterTypes()[0];
        if (ValueComposite.class.isAssignableFrom(valueType)) {
            ValueDescriptor valueDescriptor = this.module.valueDescriptor(valueType.getName());
            for (PropertyDescriptor propertyDescriptor : valueDescriptor.state().properties()) {
                String value = this.getValue(propertyDescriptor.qualifiedName().name(), queryAsForm, entityAsForm);
                if (value == null && propertyDescriptor.initialValue() != null) {
                    value = propertyDescriptor.initialValue().toString();
                }
                form.add(propertyDescriptor.qualifiedName().name(), value);
            }
        } else if (valueType.isInterface() && contextMethod.getParameterTypes().length == 1) {
            form.add("entity", this.getValue("entity", queryAsForm, entityAsForm));
        } else {
            int idx = 0;
            for (Object[] objectArray : contextMethod.getParameterAnnotations()) {
                Name name = (Name)Iterables.first((Iterable)Iterables.filter((Specification)Annotations.isType(Name.class), (Iterable)Iterables.iterable((Object[])objectArray)));
                String value = this.getValue(name.value(), queryAsForm, entityAsForm);
                String paramName = name != null ? name.value() : "param" + idx;
                form.add(paramName, value);
                ++idx;
            }
        }
        return form;
    }

    private String getValue(String name, Form queryAsForm, Form entityAsForm) {
        String value = queryAsForm.getFirstValue(name);
        if (value == null) {
            value = entityAsForm.getFirstValue(name);
        }
        return value;
    }
}

