/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.client.responsereader;

import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.ResponseReader;

public class JSONResponseReader
implements ResponseReader {
    @Structure
    Module module;

    @Override
    public Object readResponse(Response response, Class<?> resultType) {
        if (response.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_JSON)) {
            if (ValueComposite.class.isAssignableFrom(resultType)) {
                String jsonValue = response.getEntityAsText();
                return this.module.valueBuilderFactory().newValueFromJSON(resultType, jsonValue);
            }
            if (resultType.equals(Form.class)) {
                try {
                    String jsonValue = response.getEntityAsText();
                    JSONObject jsonObject = new JSONObject(jsonValue);
                    Iterator keys = jsonObject.keys();
                    Form form = new Form();
                    while (keys.hasNext()) {
                        Object key = keys.next();
                        form.set(key.toString(), jsonObject.get(key.toString()).toString());
                    }
                    return form;
                }
                catch (JSONException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
        return null;
    }
}

