/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.client.requestwriter;

import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.Qi4jSPI;
import org.qi4j.spi.property.PropertyTypeDescriptor;
import org.qi4j.spi.value.ValueDescriptor;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.RequestWriter;

public class ValueCompositeRequestWriter
implements RequestWriter {
    @Structure
    private Qi4jSPI spi;

    @Override
    public boolean writeRequest(Object requestObject, Request request) throws ResourceException {
        if (requestObject instanceof ValueComposite) {
            ValueComposite valueObject = (ValueComposite)requestObject;
            if (request.getMethod().equals((Object)Method.GET)) {
                StateHolder holder = this.spi.getState(valueObject);
                final ValueDescriptor descriptor = this.spi.getValueDescriptor(valueObject);
                final Reference ref = request.getResourceRef();
                ref.setQuery(null);
                holder.visitProperties((StateHolder.StateVisitor)new StateHolder.StateVisitor<RuntimeException>(){

                    public void visitProperty(QualifiedName name, Object value) {
                        if (value != null) {
                            PropertyTypeDescriptor propertyDesc = (PropertyTypeDescriptor)descriptor.state().getPropertyByQualifiedName(name);
                            String queryParam = propertyDesc.propertyType().type().toQueryParameter(value);
                            ref.addQueryParameter(name.name(), queryParam);
                        }
                    }
                });
            } else {
                request.setEntity((Representation)new StringRepresentation((CharSequence)valueObject.toJSON(), MediaType.APPLICATION_JSON, null, CharacterSet.UTF_8));
            }
            return true;
        }
        return false;
    }
}

