/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.client;

import java.util.Collections;
import java.util.Locale;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ClientInfo;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import se.streamsource.dci.restlet.client.ClientCache;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.restlet.client.NullResponseHandler;
import se.streamsource.dci.restlet.client.RequestWriterDelegator;
import se.streamsource.dci.restlet.client.ResponseHandler;
import se.streamsource.dci.restlet.client.ResponseReaderDelegator;

public class CommandQueryClientFactory {
    @Structure
    private Module module;
    @Uses
    @Optional
    private ClientCache cache;
    @Uses
    @Optional
    private ResponseHandler handler = new NullResponseHandler();
    @Uses
    private ResponseReaderDelegator readerDelegator;
    @Uses
    private RequestWriterDelegator requestWriterDelegator;
    private Uniform client;

    public CommandQueryClientFactory(final @Uses Uniform client) {
        this.client = new Uniform(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Request request, Response response) {
                Response oldResponse = Response.getCurrent();
                try {
                    client.handle(request, response);
                }
                finally {
                    Response.setCurrent((Response)oldResponse);
                }
            }
        };
    }

    public CommandQueryClient newClient(Reference reference) {
        return (CommandQueryClient)this.module.objectBuilderFactory().newObjectBuilder(CommandQueryClient.class).use(new Object[]{this, reference}).newInstance();
    }

    ResponseHandler getHandler() {
        return this.handler;
    }

    void updateCommandRequest(Request request) {
        ClientInfo info = new ClientInfo();
        info.setAgent("Streamflow");
        info.setAcceptedMediaTypes(Collections.singletonList(new Preference((Metadata)MediaType.APPLICATION_JSON)));
        info.setAcceptedLanguages(Collections.singletonList(new Preference((Metadata)new Language(Locale.getDefault().getLanguage()))));
        request.setClientInfo(info);
        if (this.cache != null) {
            this.cache.updateCommandConditions(request);
        }
    }

    void updateQueryRequest(Request request) {
        ClientInfo info = new ClientInfo();
        info.setAcceptedMediaTypes(Collections.singletonList(new Preference((Metadata)MediaType.APPLICATION_JSON)));
        info.setAcceptedLanguages(Collections.singletonList(new Preference((Metadata)new Language(Locale.getDefault().getLanguage()))));
        request.setClientInfo(info);
    }

    void updateCache(Response response) {
        if (this.cache != null) {
            this.cache.updateCache(response);
        }
    }

    Uniform getClient() {
        return this.client;
    }

    <T> T readResponse(Response response, Class<T> queryResult) {
        return (T)this.readerDelegator.readResponse(response, queryResult);
    }

    public void writeRequest(Request request, Object queryRequest) {
        if (!this.requestWriterDelegator.writeRequest(queryRequest, request)) {
            throw new IllegalArgumentException("Illegal query request type:" + queryRequest.getClass().getName());
        }
    }
}

