/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.restlet.client;

import java.io.IOException;
import java.io.Serializable;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.Iterables;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClientFactory;
import se.streamsource.dci.restlet.client.ResponseHandler;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;

public class CommandQueryClient {
    @Uses
    private CommandQueryClientFactory cqcFactory;
    @Uses
    private Reference reference;
    private ResourceValue resourceValue;

    public Reference getReference() {
        return this.reference;
    }

    public ResourceValue getResource() {
        return this.resourceValue;
    }

    public synchronized ResourceValue query() throws ResourceException {
        this.resourceValue = this.query("", ResourceValue.class);
        return this.resourceValue;
    }

    public synchronized <T> T query(String operation, Class<T> queryResult) throws ResourceException {
        return this.query(operation, queryResult, null);
    }

    public synchronized <T> T query(String operation, Class<T> queryResult, Object queryRequest) throws ResourceException {
        Response response = this.invokeQuery(operation, queryRequest);
        if (response.getStatus().isSuccess()) {
            this.cqcFactory.updateCache(response);
            return this.cqcFactory.readResponse(response, queryResult);
        }
        this.handleError(response);
        return null;
    }

    public synchronized <T> T queryLink(LinkValue link, Class<T> queryResult) {
        return this.query((String)link.href().get(), queryResult);
    }

    public boolean hasQueryWithRelation(String relation) {
        return Iterables.matchesAny(Links.withRel(relation), (Iterable)((Iterable)this.resourceValue.queries().get()));
    }

    public synchronized <T> T queryByRelation(String relation, Class<T> resultClass) {
        LinkValue link = (LinkValue)Iterables.first((Iterable)Iterables.filter(Links.withRel(relation), (Iterable)((Iterable)this.resourceValue.queries().get())));
        if (link == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return this.queryLink(link, resultClass);
    }

    public boolean hasCommandWithRelation(String relation) {
        return Iterables.matchesAny(Links.withRel(relation), (Iterable)((Iterable)this.resourceValue.commands().get()));
    }

    public synchronized void command(String relation) throws ResourceException {
        LinkValue link = (LinkValue)Iterables.first((Iterable)Iterables.filter(Links.withRel(relation), (Iterable)((Iterable)this.resourceValue.commands().get())));
        if (link == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (Links.withClass("idempotent").satisfiedBy((Object)link)) {
            this.putCommand((String)link.href().get());
        } else {
            this.postLink(link);
        }
    }

    public synchronized void postLink(LinkValue link) throws ResourceException {
        this.postCommand((String)link.href().get(), new EmptyRepresentation());
    }

    public synchronized void postLink(LinkValue link, Object requestObject) throws ResourceException {
        this.postCommand((String)link.href().get(), requestObject);
    }

    public synchronized void postCommand(String operation) throws ResourceException {
        this.postCommand(operation, new EmptyRepresentation());
    }

    public synchronized void postCommand(String operation, Object requestObject) throws ResourceException {
        this.postCommand(operation, requestObject, this.cqcFactory.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postCommand(String operation, Object requestObject, ResponseHandler responseHandler) throws ResourceException {
        Reference ref = new Reference(this.reference.toUri().toString() + operation);
        Request request = new Request(Method.POST, ref);
        this.cqcFactory.writeRequest(request, requestObject);
        this.cqcFactory.updateCommandRequest(request);
        Response response = new Response(request);
        this.cqcFactory.getClient().handle(request, response);
        try {
            if (response.getStatus().isSuccess()) {
                this.cqcFactory.updateCache(response);
                responseHandler.handleResponse(response);
            } else {
                this.handleError(response);
            }
        }
        finally {
            try {
                response.getEntity().exhaust();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void create() throws ResourceException {
        this.putCommand(null);
    }

    public synchronized void putCommand(String operation) throws ResourceException {
        this.putCommand(operation, null, this.cqcFactory.getHandler());
    }

    public synchronized void putCommand(String operation, Object requestObject) throws ResourceException {
        this.postCommand(operation, requestObject, this.cqcFactory.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putCommand(String operation, Object requestObject, ResponseHandler responseHandler) throws ResourceException {
        Reference ref = new Reference(this.reference.toUri().toString());
        if (operation != null) {
            ref = ref.addSegment(operation);
        }
        Request request = new Request(Method.PUT, ref);
        this.cqcFactory.writeRequest(request, requestObject);
        this.cqcFactory.updateCommandRequest(request);
        int tries = 3;
        while (true) {
            try {
                Response response = new Response(request);
                this.cqcFactory.getClient().handle(request, response);
                try {
                    if (response.getStatus().isSuccess()) {
                        this.cqcFactory.updateCache(response);
                        responseHandler.handleResponse(response);
                    } else {
                        this.handleError(response);
                    }
                }
                finally {
                    try {
                        response.getEntity().exhaust();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (ResourceException e) {
                if (e.getStatus().equals((Object)Status.CONNECTOR_ERROR_COMMUNICATION) || e.getStatus().equals((Object)Status.CONNECTOR_ERROR_CONNECTION)) {
                    if (tries == 0) {
                        throw e;
                    }
                    --tries;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public synchronized void delete() throws ResourceException {
        this.delete(this.cqcFactory.getHandler());
    }

    public synchronized void delete(ResponseHandler responseHandler) throws ResourceException {
        Request request = new Request(Method.DELETE, new Reference(this.reference.toUri()).toString());
        this.cqcFactory.updateCommandRequest(request);
        int tries = 3;
        while (true) {
            Response response = new Response(request);
            try {
                this.cqcFactory.getClient().handle(request, response);
                if (!response.getStatus().isSuccess()) {
                    this.handleError(response);
                    break;
                }
                this.cqcFactory.updateCache(response);
                responseHandler.handleResponse(response);
            }
            catch (ResourceException e) {
                if (e.getStatus().equals((Object)Status.CONNECTOR_ERROR_COMMUNICATION) || e.getStatus().equals((Object)Status.CONNECTOR_ERROR_CONNECTION)) {
                    if (tries == 0) {
                        throw e;
                    }
                    --tries;
                    continue;
                }
                throw e;
            }
            finally {
                try {
                    response.getEntity().exhaust();
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    public synchronized CommandQueryClient getSubClient(String pathSegment) {
        Reference subReference = this.reference.clone().addSegment(pathSegment).addSegment("");
        return this.cqcFactory.newClient(subReference);
    }

    public synchronized CommandQueryClient getClient(String relativePath) {
        if (relativePath.startsWith("http://")) {
            return this.cqcFactory.newClient(new Reference(relativePath));
        }
        Reference reference = this.reference.clone();
        if (relativePath.startsWith("/")) {
            reference.setPath(relativePath);
        } else {
            reference.setPath(reference.getPath() + relativePath);
            reference = reference.normalize();
        }
        return this.cqcFactory.newClient(reference);
    }

    public synchronized CommandQueryClient getClient(LinkValue link) {
        if (link == null) {
            throw new NullPointerException("No link specified");
        }
        return this.getClient((String)link.href().get());
    }

    private Object handleError(Response response) throws ResourceException {
        if (response.getStatus().equals((Object)Status.SERVER_ERROR_INTERNAL)) {
            if (MediaType.APPLICATION_JAVA_OBJECT.equals((Object)response.getEntity().getMediaType())) {
                try {
                    Serializable exception = new ObjectRepresentation(response.getEntity()).getObject();
                    throw new ResourceException((Throwable)exception);
                }
                catch (IOException e) {
                    throw new ResourceException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, response.getEntityAsText());
        }
        if (response.getEntity() != null) {
            String text = response.getEntityAsText();
            throw new ResourceException(response.getStatus().getCode(), response.getStatus().getName(), text, response.getRequest().getResourceRef().toUri().toString());
        }
        throw new ResourceException(response.getStatus().getCode(), response.getStatus().getName(), response.getStatus().getDescription(), response.getRequest().getResourceRef().toUri().toString());
    }

    private Response invokeQuery(String operation, Object queryRequest) throws ResourceException {
        Reference ref = new Reference(this.reference.toUri().toString() + operation);
        Request request = new Request(Method.GET, ref);
        if (queryRequest != null) {
            this.cqcFactory.writeRequest(request, queryRequest);
        }
        this.cqcFactory.updateQueryRequest(request);
        Response response = new Response(request);
        this.cqcFactory.getClient().handle(request, response);
        return response;
    }

    public String toString() {
        return this.reference.toString();
    }
}

