/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.api;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.api.InteractionConstraint;
import se.streamsource.dci.api.InteractionConstraintDeclaration;
import se.streamsource.dci.api.RoleMap;

@InteractionConstraintDeclaration(value=ServiceAvailableConstraint.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ServiceAvailable {
    public Class service();

    public boolean availability() default true;

    public static class ServiceAvailableConstraint
    implements InteractionConstraint<ServiceAvailable> {
        @Structure
        Module module;

        @Override
        public boolean isValid(ServiceAvailable serviceAvailable, RoleMap roleMap) {
            ServiceReference ref = this.module.serviceFinder().findService((Type)serviceAvailable.service());
            return serviceAvailable.availability() ? ref != null && ref.isAvailable() : ref == null || !ref.isAvailable();
        }
    }
}

