/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoleMap {
    private static ThreadLocal<RoleMap> currentRoleMap = new ThreadLocal();
    private Map<Class, Object> roles = new HashMap<Class, Object>();
    private RoleMap parentRoleMap;

    public static RoleMap current() {
        return currentRoleMap.get();
    }

    public static <T> T role(Class<T> roleClass) {
        RoleMap map = currentRoleMap.get();
        if (map == null) {
            throw new IllegalStateException("No current role map");
        }
        return map.get(roleClass);
    }

    public static void setCurrentRoleMap(RoleMap roleMap) {
        currentRoleMap.set(roleMap);
    }

    public static void newCurrentRoleMap() {
        currentRoleMap.set(new RoleMap());
    }

    public static void clearCurrentRoleMap() {
        currentRoleMap.remove();
    }

    public RoleMap() {
    }

    public RoleMap(RoleMap parentRoleMap) {
        this.parentRoleMap = parentRoleMap;
    }

    public void set(Object object, Class ... roleClasses) {
        if (object == null) {
            for (Class roleClass : roleClasses) {
                this.roles.remove(roleClass);
            }
        } else if (roleClasses.length == 0) {
            this.roles.put(object.getClass(), object);
        } else {
            for (Class roleClass : roleClasses) {
                this.roles.put(roleClass, object);
            }
        }
    }

    public <T> T get(Class<T> roleClass) throws IllegalArgumentException {
        Object object = this.roles.get(roleClass);
        if (object == null) {
            for (Map.Entry<Class, Object> entry : this.roles.entrySet()) {
                if (!roleClass.isAssignableFrom(entry.getKey())) continue;
                return roleClass.cast(entry.getValue());
            }
        } else {
            return roleClass.cast(object);
        }
        if (this.parentRoleMap == null) {
            throw new IllegalArgumentException("No object in roleMap for role:" + roleClass.getSimpleName());
        }
        return this.parentRoleMap.get(roleClass);
    }

    public <T> List<T> getAll(Class<T> roleClass) {
        ArrayList list = new ArrayList();
        this.getAll0(roleClass, list);
        return list;
    }

    private <T> void getAll0(Class<T> roleClass, List<T> list) {
        for (Object obj : this.roles.values()) {
            if (!roleClass.isInstance(obj) || list.contains(obj)) continue;
            list.add(obj);
        }
        if (this.parentRoleMap != null) {
            this.parentRoleMap.getAll0(roleClass, list);
        }
    }

    public void map(Class fromRoleClass, Class ... toRoleClasses) {
        Object object = this.get(fromRoleClass);
        for (Class toRoleClass : toRoleClasses) {
            if (!toRoleClass.isInstance(object)) {
                throw new IllegalArgumentException(object + " does not implement role type " + toRoleClass.getName());
            }
            this.roles.put(toRoleClass, object);
        }
    }
}

