/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.dci.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qi4j.api.composite.TransientComposite;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.api.constraint.ConstraintDeclaration;
import org.qi4j.api.constraint.Constraints;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.object.NoSuchObjectException;
import org.qi4j.api.structure.Module;
import org.qi4j.spi.structure.ModuleSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.api.InteractionConstraint;
import se.streamsource.dci.api.InteractionConstraintDeclaration;
import se.streamsource.dci.api.InteractionConstraints;
import se.streamsource.dci.api.InteractionValidation;
import se.streamsource.dci.api.RequiresValid;
import se.streamsource.dci.api.RoleMap;

public class InteractionConstraintsService
implements InteractionConstraints {
    @Structure
    Module module;
    Logger logger = LoggerFactory.getLogger(InteractionConstraintsService.class);
    private Map<Method, InteractionConstraintsBinding> methodsConstraints = new ConcurrentHashMap<Method, InteractionConstraintsBinding>();
    private Map<Class, InteractionConstraintsBinding> classConstraints = new ConcurrentHashMap<Class, InteractionConstraintsBinding>();

    @Override
    public boolean isValid(Method method, RoleMap roleMap, ModuleSPI module) {
        return this.getConstraints(method, module).isValid(roleMap);
    }

    @Override
    public boolean isValid(Class resourceClass, RoleMap roleMap, ModuleSPI module) {
        return this.getConstraints(resourceClass, module).isValid(roleMap);
    }

    private InteractionConstraintsBinding getConstraints(Method method, ModuleSPI module) {
        InteractionConstraintsBinding constraintBindings = this.methodsConstraints.get(method);
        if (constraintBindings == null) {
            constraintBindings = this.findConstraints(method, module);
            this.methodsConstraints.put(method, constraintBindings);
        }
        return constraintBindings;
    }

    private InteractionConstraintsBinding getConstraints(Class aClass, ModuleSPI module) {
        InteractionConstraintsBinding constraintBindings = this.classConstraints.get(aClass);
        if (constraintBindings == null) {
            constraintBindings = this.findConstraints(aClass, module);
            this.classConstraints.put(aClass, constraintBindings);
        }
        return constraintBindings;
    }

    private InteractionConstraintsBinding findConstraints(Method method, ModuleSPI module) {
        ArrayList<Binding> methodConstraintBindings = new ArrayList<Binding>();
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType().equals(RequiresValid.class)) {
                RequiresValid requiresValid = (RequiresValid)annotation;
                Class[] contextClass = method.getDeclaringClass();
                if (!InteractionValidation.class.isAssignableFrom((Class<?>)contextClass)) continue;
                InteractionValidation validation = null;
                validation = TransientComposite.class.isAssignableFrom((Class<?>)contextClass) ? (InteractionValidation)module.transientBuilderFactory().newTransient((Class)contextClass) : (InteractionValidation)module.objectBuilderFactory().newObject((Class)contextClass);
                methodConstraintBindings.add(new RequiresValidBinding(requiresValid, validation));
                continue;
            }
            if (annotation.annotationType().getAnnotation(ConstraintDeclaration.class) != null) {
                Constraints constraints = annotation.annotationType().getAnnotation(Constraints.class);
                for (Class aClass : constraints.value()) {
                    try {
                        Constraint constraint = (Constraint)aClass.newInstance();
                        Class roleClass = (Class)((ParameterizedType)aClass.getGenericInterfaces()[0]).getActualTypeArguments()[1];
                        ConstraintBinding constraintBinding = new ConstraintBinding((Constraint<Annotation, Object>)constraint, annotation, roleClass);
                        methodConstraintBindings.add(constraintBinding);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (annotation.annotationType().getAnnotation(InteractionConstraintDeclaration.class) == null) continue;
            Class<InteractionConstraint<?>> constraintClass = annotation.annotationType().getAnnotation(InteractionConstraintDeclaration.class).value();
            InteractionConstraint<Annotation> constraint = null;
            try {
                try {
                    constraint = (InteractionConstraint<Annotation>)module.objectBuilderFactory().newObject(constraintClass);
                }
                catch (NoSuchObjectException e) {
                    constraint = constraintClass.newInstance();
                }
            }
            catch (Exception e) {
                continue;
            }
            InteractionConstraintBinding constraintBinding = new InteractionConstraintBinding(constraint, annotation);
            methodConstraintBindings.add(constraintBinding);
        }
        if (methodConstraintBindings.isEmpty()) {
            methodConstraintBindings = null;
        }
        return new InteractionConstraintsBinding(methodConstraintBindings);
    }

    private InteractionConstraintsBinding findConstraints(Class aClass, ModuleSPI module) {
        ArrayList<Binding> classConstraintBindings = new ArrayList<Binding>();
        for (Annotation annotation : aClass.getAnnotations()) {
            if (annotation.annotationType().getAnnotation(ConstraintDeclaration.class) != null) {
                Constraints constraints = annotation.annotationType().getAnnotation(Constraints.class);
                for (Class constraintClass : constraints.value()) {
                    try {
                        Constraint constraint = (Constraint)constraintClass.newInstance();
                        Class roleClass = (Class)((ParameterizedType)constraint.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[1];
                        ConstraintBinding constraintBinding = new ConstraintBinding((Constraint<Annotation, Object>)constraint, annotation, roleClass);
                        classConstraintBindings.add(constraintBinding);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (annotation.annotationType().getAnnotation(InteractionConstraintDeclaration.class) == null) continue;
            Class<InteractionConstraint<?>> constraintClass = annotation.annotationType().getAnnotation(InteractionConstraintDeclaration.class).value();
            InteractionConstraint<Annotation> constraint = null;
            try {
                try {
                    constraint = (InteractionConstraint<Annotation>)module.objectBuilderFactory().newObject(constraintClass);
                }
                catch (NoSuchObjectException e) {
                    constraint = constraintClass.newInstance();
                }
            }
            catch (Exception e) {
                continue;
            }
            InteractionConstraintBinding constraintBinding = new InteractionConstraintBinding(constraint, annotation);
            classConstraintBindings.add(constraintBinding);
        }
        if (classConstraintBindings.isEmpty()) {
            classConstraintBindings = null;
        }
        return new InteractionConstraintsBinding(classConstraintBindings);
    }

    public class InteractionConstraintBinding
    implements Binding {
        InteractionConstraint<Annotation> constraint;
        Annotation annotation;

        public InteractionConstraintBinding(InteractionConstraint<Annotation> constraint, Annotation annotation) {
            this.constraint = constraint;
            this.annotation = annotation;
        }

        @Override
        public boolean isValid(RoleMap roleMap) {
            try {
                return this.constraint.isValid(this.annotation, roleMap);
            }
            catch (Throwable e) {
                InteractionConstraintsService.this.logger.warn("Could not check constraint " + this.constraint.getClass().getName(), e);
                return false;
            }
        }
    }

    public class ConstraintBinding
    implements Binding {
        Constraint<Annotation, Object> constraint;
        Annotation annotation;
        Class roleClass;

        public ConstraintBinding(Constraint<Annotation, Object> constraint, Annotation annotation, Class roleClass) {
            this.constraint = constraint;
            this.annotation = annotation;
            this.roleClass = roleClass;
        }

        @Override
        public boolean isValid(RoleMap roleMap) {
            try {
                RoleMap checkedObject = this.roleClass.equals(RoleMap.class) ? roleMap : roleMap.get(this.roleClass);
                return this.constraint.isValid(this.annotation, (Object)checkedObject);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (Throwable e) {
                InteractionConstraintsService.this.logger.warn("Could not check constraint " + this.constraint.getClass().getName(), e);
                return false;
            }
        }
    }

    public class RequiresValidBinding
    implements Binding {
        RequiresValid annotation;
        private final InteractionValidation validation;

        public RequiresValidBinding(RequiresValid annotation, InteractionValidation validation) {
            this.validation = validation;
            this.annotation = annotation;
        }

        @Override
        public boolean isValid(RoleMap roleMap) {
            try {
                return this.validation.isValid(this.annotation.value());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (Throwable e) {
                InteractionConstraintsService.this.logger.warn("Could not check validation constraint for '" + this.annotation.value() + "'", e);
                return false;
            }
        }
    }

    public static class InteractionConstraintsBinding {
        List<Binding> bindings;

        public InteractionConstraintsBinding(List<Binding> bindings) {
            this.bindings = bindings;
        }

        public boolean isValid(RoleMap roleMap) {
            if (this.bindings != null) {
                for (Binding constraintBinding : this.bindings) {
                    if (constraintBinding.isValid(roleMap)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    static interface Binding {
        public boolean isValid(RoleMap var1);
    }
}

