/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.table;

import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;

public class SeparatorTableUI
extends BasicTableUI {
    private Class separatorClass;

    public SeparatorTableUI(Class separatorClass) {
        this.separatorClass = separatorClass;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle oldClipBounds = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getModel().getRowCount() <= 0 || !bounds.intersects(oldClipBounds)) {
            return;
        }
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        int tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        clipBounds.width = Math.min(clipBounds.width, tableWidth);
        g.setClip(clipBounds);
        int firstIndex = this.table.rowAtPoint(new Point(0, clipBounds.y));
        int lastIndex = this.table.getRowCount() - 1;
        Rectangle rowRect = new Rectangle(0, 0, tableWidth, this.table.getRowHeight() + this.table.getRowMargin());
        rowRect.y = firstIndex * rowRect.height;
        for (int index = firstIndex; index <= lastIndex; ++index) {
            if (rowRect.intersects(clipBounds)) {
                this.paintRow(g, index);
            }
            rowRect.y += rowRect.height;
        }
        g.setClip(oldClipBounds);
    }

    private void paintRow(Graphics g, int row) {
        Rectangle rect = g.getClipBounds();
        EventTableModel tableModel = (EventTableModel)this.table.getModel();
        int numColumns = this.table.getColumnCount();
        if (tableModel.getRowCount() > row && this.separatorClass.isInstance(tableModel.getElementAt(row))) {
            Rectangle cellRect = this.table.getCellRect(row, 0, true);
            this.paintCell(g, cellRect, row, 0);
        } else {
            for (int column = 0; column < numColumns; ++column) {
                Rectangle cellRect = this.table.getCellRect(row, column, true);
                if (!cellRect.intersects(rect)) continue;
                this.paintCell(g, cellRect, row, column);
            }
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        int spacingHeight = this.table.getRowMargin();
        int spacingWidth = this.table.getColumnModel().getColumnMargin();
        cellRect.setBounds(cellRect.x + spacingWidth / 2, cellRect.y + spacingHeight / 2, cellRect.width - spacingWidth, cellRect.height - spacingHeight);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer;
            if (this.table.getModel().getRowCount() > row && this.separatorClass.isInstance(((EventTableModel)this.table.getModel()).getElementAt(row))) {
                Color c = g.getColor();
                g.setColor(this.table.getGridColor());
                g.drawRect(cellRect.x, cellRect.y, cellRect.width - 1, cellRect.height - 1);
                g.setColor(c);
                renderer = this.table.getDefaultRenderer(this.separatorClass);
            } else {
                renderer = this.table.getCellRenderer(row, column);
            }
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }
}

