/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Image;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class i18n {
    public static final int ICON_16 = 16;
    public static final int ICON_24 = 24;

    public static String text(Enum resource, Object ... arguments) {
        String string = i18n.getResourceMap(resource).getString(resource.name(), new Object[0]);
        if (string == null) {
            string = "#" + resource.name();
        }
        if (arguments.length > 0) {
            MessageFormat format = new MessageFormat(string);
            string = format.format(arguments);
        }
        return string;
    }

    public static int mnemonic(Enum resource) {
        ResourceMap resourceMap = i18n.getResourceMap(resource);
        Integer keycode = resourceMap.getKeyCode(resource.name());
        if (keycode == null) {
            return 0;
        }
        return keycode;
    }

    public static ImageIcon icon(Enum resource) {
        return i18n.icon(resource, 24);
    }

    public static ImageIcon icon(Enum resource, int size) {
        ResourceMap resourceMap = i18n.getResourceMap(resource);
        ImageIcon icon = resourceMap.getImageIcon(resource.name());
        return i18n.icon(icon, size);
    }

    public static ImageIcon icon(ImageIcon icon, int size) {
        if (icon == null) {
            return null;
        }
        Image image = icon.getImage();
        if (icon.getIconWidth() != size) {
            image = image.getScaledInstance(size, size, 4);
            icon = new ImageIcon(image);
        }
        return icon;
    }

    private static ResourceMap getResourceMap(Enum resource) {
        ResourceMap resourceMap = null;
        try {
            resourceMap = Application.getInstance().getContext().getResourceMap(resource.getClass());
        }
        catch (Exception e) {
            resourceMap = new ResourceMap(null, i18n.class.getClassLoader(), new String[]{resource.getClass().getName()});
        }
        if (resourceMap == null) {
            throw new IllegalArgumentException("No resource map found for resource:" + resource);
        }
        return resourceMap;
    }
}

