/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class WeakModelMap<K, V>
implements Iterable<V> {
    Map<K, WeakReference<V>> models = new HashMap<K, WeakReference<V>>();

    public V get(K key) {
        WeakReference<V> model = this.models.get(key);
        if (model == null || model.get() == null) {
            model = new WeakReference<V>(this.newModel(key));
            this.models.put(key, model);
        }
        return (V)model.get();
    }

    protected abstract V newModel(K var1);

    public void clear() {
        this.models.clear();
    }

    @Override
    public Iterator<V> iterator() {
        ArrayList list = new ArrayList();
        for (WeakReference<V> vWeakReference : this.models.values()) {
            if (vWeakReference.get() == null) continue;
            list.add(vWeakReference.get());
        }
        return list.iterator();
    }

    public void remove(K key) {
        this.models.remove(key);
    }
}

