/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXLabel;
import org.qi4j.api.common.QualifiedName;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.StateHolder;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.ListMap;
import org.qi4j.api.value.ValueComposite;
import org.qi4j.spi.Qi4jSPI;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.StreamflowJXColorSelectionButton;
import se.streamsource.streamflow.client.util.StreamflowSelectableLabel;

public class ValueBinder {
    @Structure
    Qi4jSPI spi;
    Map<Class<? extends Component>, Binder> binders = new HashMap<Class<? extends Component>, Binder>();
    ListMap<String, Binding> bindings = new ListMap();

    public ValueBinder() {
        DefaultBinder defaultBinder = new DefaultBinder();
        this.registerBinder(defaultBinder, JXLabel.class, JLabel.class, JTextField.class, JTextArea.class, JTextPane.class, JEditorPane.class, JScrollPane.class, JPasswordField.class, JCheckBox.class, JXDatePicker.class, JComboBox.class, JRadioButton.class, RemovableLabel.class, StreamflowJXColorSelectionButton.class, StreamflowSelectableLabel.class);
    }

    public void registerBinder(Binder binder, Class<? extends Component> ... componentTypes) {
        for (Class<? extends Component> componentType : componentTypes) {
            this.binders.put(componentType, binder);
        }
    }

    public <T extends Component> T bind(String name, T component) {
        return this.bind(name, component, null);
    }

    public <T extends Component> T bind(String name, T component, Converter converter) {
        Binder binder;
        Object boundComponent = component;
        if (boundComponent instanceof JScrollPane) {
            boundComponent = ((JScrollPane)boundComponent).getViewport().getView();
        }
        if ((binder = this.binders.get(boundComponent.getClass())) == null) {
            throw new IllegalArgumentException("No binder registered for component type:" + boundComponent.getClass().getSimpleName());
        }
        this.bindings.add((Object)name, (Object)new Binding(converter, (Component)boundComponent, binder));
        return component;
    }

    public void update(ValueComposite source) {
        this.spi.getState(source).visitProperties((StateHolder.StateVisitor)new StateHolder.StateVisitor<RuntimeException>(){

            public void visitProperty(QualifiedName name, Object value) throws RuntimeException {
                Iterable binding = (Iterable)ValueBinder.this.bindings.get((Object)name.name());
                if (binding != null) {
                    for (Binding binding1 : binding) {
                        binding1.update(value);
                    }
                }
            }
        });
    }

    public void update(Form form) {
        for (Parameter parameter : form) {
            List bindings1 = (List)this.bindings.get((Object)parameter.getName());
            if (bindings1 == null) continue;
            for (Binding binding : bindings1) {
                binding.update(parameter.getValue());
            }
        }
    }

    public void update(String name, Object value) {
        List bindings1 = (List)this.bindings.get((Object)name);
        if (bindings1 != null) {
            for (Binding binding : bindings1) {
                binding.update(value);
            }
        }
    }

    public static interface Converter<FROM, TO> {
        public TO toComponent(FROM var1);
    }

    private class DefaultBinder
    implements Binder {
        @Override
        public void updateComponent(Component component, Object value) {
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setText(value == null ? "" : value.toString());
            } else if (component instanceof JPasswordField) {
                JPasswordField passwordField = (JPasswordField)component;
                passwordField.setText(value == null ? "" : value.toString());
            } else if (component instanceof JTextComponent) {
                JTextComponent textField = (JTextComponent)component;
                String text = value == null ? "" : value.toString();
                textField.setText(text);
                textField.setCaretPosition(0);
            } else if (component instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)component;
                if (value instanceof String) {
                    value = Boolean.parseBoolean(value.toString());
                }
                checkBox.setSelected((Boolean)value);
            } else if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setText(value == null ? "" : value.toString());
            } else if (component instanceof JXDatePicker) {
                JXDatePicker datePicker = (JXDatePicker)component;
                if (value instanceof String) {
                    if (!((String)value).isEmpty()) {
                        datePicker.setDate(DateFunctions.fromString((String)((String)value)));
                    }
                } else {
                    datePicker.setDate((Date)value);
                }
            } else if (component instanceof StreamflowJXColorSelectionButton) {
                StreamflowJXColorSelectionButton colorSelectionButton = (StreamflowJXColorSelectionButton)component;
                if (value instanceof String && !((String)value).isEmpty()) {
                    colorSelectionButton.setBackground(new Color(Integer.parseInt((String)value)));
                }
            } else if (component instanceof JComboBox) {
                JComboBox box = (JComboBox)component;
                box.setSelectedItem(value);
            } else if (component instanceof JRadioButton) {
                JRadioButton button = (JRadioButton)component;
                button.setSelected(button.getActionCommand().equals(value.toString()));
            } else if (component instanceof RemovableLabel) {
                RemovableLabel label = (RemovableLabel)component;
                label.setRemoveLink((LinkValue)value);
            }
        }
    }

    public static interface Binder {
        public void updateComponent(Component var1, Object var2);
    }

    public class Binding {
        Converter converter;
        Component component;
        Binder binder;

        public Binding(Converter converter, Component component, Binder binder) {
            this.converter = converter;
            this.component = component;
            this.binder = binder;
        }

        void update(Object value) {
            if (this.converter != null) {
                value = this.converter.toComponent(value);
            }
            this.binder.updateComponent(this.component, value);
        }
    }
}

