/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.qi4j.api.injection.scope.Service;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.util.HtmlErrorMessageExtractor;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Service
    private StreamflowApplication main;
    @Service
    private DialogService dialogs;
    private boolean processing = false;

    public void uncaughtException(Throwable e) {
        this.uncaughtException(Thread.currentThread(), e);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        final Throwable ex = this.unwrap(e);
        Object source = null;
        try {
            source = EventQueue.getCurrentEvent().getSource();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        final JFrame frame = source instanceof Component ? (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)source) : this.main.getMainFrame();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block24: {
                    if (!UncaughtExceptionHandler.this.processing) {
                        try {
                            Throwable cause;
                            UncaughtExceptionHandler.this.processing = true;
                            Throwable throwable = cause = ex instanceof OperationException ? ex.getCause() : ex;
                            if (cause instanceof ResourceException) {
                                ResourceException re = (ResourceException)cause;
                                if (re.getStatus().equals((Object)Status.CLIENT_ERROR_FORBIDDEN)) {
                                    JXDialog dialog = new JXDialog(frame, (JComponent)new JLabel(i18n.text(StreamflowResources.operation_not_permitted, new Object[0])));
                                    dialog.pack();
                                    dialog.setLocationRelativeTo((Component)frame);
                                    UncaughtExceptionHandler.this.main.show((JDialog)dialog);
                                    return;
                                }
                                if (re.getStatus().equals((Object)Status.CLIENT_ERROR_CONFLICT) || re.getStatus().equals((Object)Status.CLIENT_ERROR_PRECONDITION_FAILED)) {
                                    if (UncaughtExceptionHandler.this.showOptionDialog(ex, frame, i18n.text((Enum)ErrorResources.concurrent_change, new Object[0])) == 0) {
                                        UncaughtExceptionHandler.this.main.callRefresh();
                                    }
                                    return;
                                }
                                if (re.getStatus().equals((Object)Status.CLIENT_ERROR_UNAUTHORIZED)) {
                                    UncaughtExceptionHandler.this.dialogs.showMessageDialog(frame, i18n.text((Enum)ErrorResources.unauthorized_access, new Object[0]), "Info");
                                    UncaughtExceptionHandler.this.main.manageAccounts();
                                    return;
                                }
                                if (re.getStatus().equals((Object)Status.CONNECTOR_ERROR_COMMUNICATION)) {
                                    UncaughtExceptionHandler.this.showErrorDialog(ex, frame, i18n.text((Enum)ErrorResources.communication_error, new Object[0]));
                                    UncaughtExceptionHandler.this.main.selectAccount();
                                    return;
                                }
                                if (re.getStatus().equals((Object)Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY)) {
                                    try {
                                        UncaughtExceptionHandler.this.showErrorDialog(ex, frame, i18n.text((Enum)ErrorResources.valueOf((String)re.getStatus().getDescription()), new Object[0]));
                                    }
                                    catch (Exception e) {
                                        UncaughtExceptionHandler.this.showErrorDialog(ex, frame, re.getMessage() + "\n" + re.getStatus().getUri(), re.getStatus().getDescription());
                                    }
                                    return;
                                }
                                UncaughtExceptionHandler.this.showErrorDialog(ex, frame, re.getMessage() + "\n" + re.getStatus().getUri());
                                return;
                            }
                            try {
                                String message = ex.getMessage();
                                if (message != null) {
                                    try {
                                        UncaughtExceptionHandler.this.showErrorDialog(ex, frame, i18n.text((Enum)ErrorResources.valueOf((String)message), new Object[0]));
                                    }
                                    catch (Exception e) {
                                        message = HtmlErrorMessageExtractor.parse(ex.getMessage());
                                        UncaughtExceptionHandler.this.showErrorDialog(ex, frame, i18n.text(StreamflowResources.valueOf(HtmlErrorMessageExtractor.parse(ex.getMessage())), new Object[0]));
                                    }
                                    break block24;
                                }
                                UncaughtExceptionHandler.this.showErrorDialog(ex, frame);
                            }
                            catch (IllegalArgumentException iae) {
                                UncaughtExceptionHandler.this.showErrorDialog(ex, frame);
                            }
                        }
                        finally {
                            UncaughtExceptionHandler.this.processing = false;
                        }
                    }
                }
            }
        });
    }

    private int showOptionDialog(Throwable ex, Frame frame, String text) {
        Object[] options = new Object[]{"OK"};
        return JOptionPane.showOptionDialog(frame, text, i18n.text((Enum)ErrorResources.error, new Object[0]), -1, 0, null, options, options[0]);
    }

    private void showErrorDialog(Throwable ex, Frame frame, String errorMsg) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(new ErrorInfo(i18n.text((Enum)ErrorResources.error, new Object[0]), errorMsg, null, i18n.text((Enum)ErrorResources.error, new Object[0]), ex, Level.SEVERE, Collections.emptyMap()));
        pane.setPreferredSize(new Dimension(700, 400));
        JXErrorPane.showDialog((Component)frame, (JXErrorPane)pane);
    }

    private void showErrorDialog(Throwable ex, Frame frame, String errorMsg, String detailedErrorMsg) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(new ErrorInfo(i18n.text((Enum)ErrorResources.error, new Object[0]), errorMsg, detailedErrorMsg, i18n.text((Enum)ErrorResources.error, new Object[0]), ex, Level.SEVERE, Collections.emptyMap()));
        pane.setPreferredSize(new Dimension(700, 400));
        JXErrorPane.showDialog((Component)frame, (JXErrorPane)pane);
    }

    private void showErrorDialog(Throwable ex, Frame frame) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(new ErrorInfo(i18n.text((Enum)ErrorResources.error, new Object[0]), ex.getMessage(), null, i18n.text((Enum)ErrorResources.error, new Object[0]), ex, Level.SEVERE, Collections.emptyMap()));
        pane.setPreferredSize(new Dimension(700, 400));
        JXErrorPane.showDialog((Component)frame, (JXErrorPane)pane);
    }

    private Throwable unwrap(Throwable e) {
        if (e instanceof OperationException) {
            return e;
        }
        if (e.getCause() != null) {
            if (e instanceof Error) {
                return this.unwrap(e.getCause());
            }
            if (e instanceof InvocationTargetException) {
                return this.unwrap(e.getCause());
            }
            return this.unwrap(e.getCause());
        }
        return e;
    }
}

