/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.SuggestModel;

public class SuggestTextField<T>
extends JPanel {
    private static final long serialVersionUID = -2427927984739983590L;
    private int MAX_LIST_LENGTH = 10;
    private int MIN_LENGTH_FOR_SEARCH = 3;
    private JList list;
    private JPopupMenu popup = new JPopupMenu();
    private DefaultListModel listModel;
    private JTextField textField;
    private SuggestModel<T> model;

    public SuggestTextField(SuggestModel<T> model) {
        this.model = model;
        this.initComponents();
    }

    public SuggestTextField(SuggestModel<T> model, int maxListLength, int minLengthForSearch) {
        this(model);
        this.MAX_LIST_LENGTH = maxListLength;
        this.MIN_LENGTH_FOR_SEARCH = minLengthForSearch;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.textField = new JTextField();
        this.add(this.textField);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JScrollPane scroll = new JScrollPane(this.list);
        this.list.setFocusable(false);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popup.add(scroll);
        this.textField.registerKeyboardAction(new ShowPopupAction(), KeyStroke.getKeyStroke(40, 0), 0);
        this.textField.registerKeyboardAction(new UpAction(), KeyStroke.getKeyStroke(38, 0), 0);
        this.textField.registerKeyboardAction(new HidePopupAction(), KeyStroke.getKeyStroke(27, 0), 0);
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 40 && e.getKeyCode() != 38 && e.getKeyCode() != 27 && e.getKeyCode() != 10) {
                    if (SuggestTextField.this.textField.getText().length() >= SuggestTextField.this.MIN_LENGTH_FOR_SEARCH) {
                        SuggestTextField.this.showPopup();
                    } else {
                        SuggestTextField.this.popup.setVisible(false);
                    }
                }
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    SuggestTextField.this.popup.setVisible(false);
                    SuggestTextField.this.handleSaveAction(SuggestTextField.this.textField.getText());
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                SuggestTextField.this.textField.setSelectionStart(SuggestTextField.this.textField.getCaretPosition());
            }
        });
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SuggestTextField.this.textField.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.list.setRequestFocusEnabled(false);
    }

    public void setBinding(final StateBinder.Binding binding) {
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (!SuggestTextField.this.popup.isVisible()) {
                    binding.updateProperty(SuggestTextField.this.textField.getText());
                    return true;
                }
                return false;
            }
        });
    }

    private void showPopup() {
        this.listModel.clear();
        for (T item : this.model.options(this.textField.getText())) {
            this.listModel.addElement(this.model.displayValue(item));
        }
        if (this.textField.isEnabled() && this.list.getModel().getSize() != 0) {
            this.textField.registerKeyboardAction(new AcceptAction(), KeyStroke.getKeyStroke(10, 0), 0);
            int size = this.list.getModel().getSize();
            this.list.setVisibleRowCount(size < this.MAX_LIST_LENGTH ? size : this.MAX_LIST_LENGTH);
            this.popup.pack();
            if (!this.popup.isVisible()) {
                this.popup.show(this.textField, 2, this.textField.getHeight());
            }
        } else {
            this.popup.setVisible(false);
        }
        this.textField.requestFocusInWindow();
    }

    public void handleAcceptAction(T selectedItem) {
        this.textField.setText(this.model.displayValue(selectedItem));
    }

    public void handleSaveAction(String text) {
    }

    private void selectNextValue() {
        int index = this.list.getSelectedIndex();
        if (index < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(index + 1);
            this.list.ensureIndexIsVisible(index + 1);
        }
    }

    private void selectPreviousValue() {
        int index = this.list.getSelectedIndex();
        if (index > 0) {
            this.list.setSelectedIndex(index - 1);
            this.list.ensureIndexIsVisible(index - 1);
        }
    }

    private class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SuggestTextField.this.textField.isEnabled() && SuggestTextField.this.popup.isVisible()) {
                SuggestTextField.this.selectPreviousValue();
            }
        }
    }

    private class HidePopupAction
    extends AbstractAction {
        private HidePopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SuggestTextField.this.popup.setVisible(false);
        }
    }

    private class AcceptAction
    extends AbstractAction {
        private AcceptAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SuggestTextField.this.handleAcceptAction(SuggestTextField.this.model.valueAt(SuggestTextField.this.list.getSelectedIndex()));
            SuggestTextField.this.popup.setVisible(false);
        }
    }

    private class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SuggestTextField.this.textField.isEnabled()) {
                if (SuggestTextField.this.popup.isVisible()) {
                    SuggestTextField.this.selectNextValue();
                } else {
                    SuggestTextField.this.showPopup();
                }
            }
        }
    }
}

