/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.qi4j.api.io.Inputs;
import org.qi4j.api.io.Outputs;
import org.restlet.representation.Representation;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.Downloadable;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class OpenAttachmentTask
extends Task<File, Void> {
    DialogService dialogs;
    private final String relativePath;
    private Component view;
    private Downloadable download;
    private String fileName;

    public OpenAttachmentTask(String fileName, String relativePath, Component view, Downloadable download, DialogService dialogs) {
        super(Application.getInstance());
        this.fileName = fileName;
        this.relativePath = relativePath;
        this.view = view;
        this.download = download;
        this.dialogs = dialogs;
        this.setUserCanCancel(false);
    }

    protected File doInBackground() throws Exception {
        this.setTitle(this.getResourceMap().getString("title", new Object[0]));
        String name = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        String type = this.fileName.substring(this.fileName.lastIndexOf(46));
        Representation representation = this.download.download(this.relativePath);
        File file = File.createTempFile(name + "_", type);
        this.setMessage(this.getResourceMap().getString("message", new Object[0]) + " " + file.getName());
        Inputs.byteBuffer((InputStream)representation.getStream(), (int)8192).transferTo(Outputs.byteBuffer((File)file));
        return file;
    }

    protected void succeeded(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.edit(file);
        }
        catch (IOException e) {
            try {
                desktop.open(file);
            }
            catch (IOException e1) {
                this.dialogs.showMessageDialog(this.view, i18n.text(WorkspaceResources.could_not_open_attachment, new Object[0]) + " " + file.getName(), "");
            }
        }
    }
}

