/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;
import java.util.Comparator;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.LinkComparator;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class LinkValueListModel
extends ResourceModel<LinksValue>
implements Refreshable,
TransactionListener {
    protected EventList<LinkValue> linkValues = new TransactionList((EventList)new BasicEventList());
    protected EventList<LinkValue> sortedValues = new SortedList(this.linkValues, (Comparator)new LinkComparator());

    @Override
    public void refresh() {
        super.refresh();
        EventListSynch.synchronize((Collection)((LinksValue)this.getIndex()).links().get(), this.linkValues);
    }

    public EventList<LinkValue> getList() {
        return this.sortedValues;
    }

    public EventList<LinkValue> getUnsortedList() {
        return this.linkValues;
    }

    public void remove(LinkValue link) {
        this.client.getClient(link).delete();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.or((Specification[])new Specification[]{Events.onEntities((String[])new String[]{this.client.getReference().getParentRef().getLastSegment()}), Events.onEntities((String[])new String[]{this.client.getReference().getLastSegment()}), Specifications.and((Specification[])new Specification[]{Events.withNames((String[])new String[]{"changedDescription"}), Events.onEntities(this.linkValues)})}), transactions)) {
            this.refresh();
        }
    }

    protected void handleException(ResourceException e) {
        if (Status.CLIENT_ERROR_CONFLICT.equals((Object)e.getStatus())) {
            throw new OperationException((Enum)ErrorResources.valueOf((String)e.getStatus().getDescription()), (Throwable)e);
        }
        throw e;
    }
}

