/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.util.FilterLinkListCellRenderer;
import se.streamsource.streamflow.client.util.LinkFilterator;

public class FilteredList
extends JPanel {
    private JTextField filterField;
    private JList list;
    public JScrollPane pane = new JScrollPane();

    public FilteredList() {
        this.setLayout(new BorderLayout());
        this.filterField = new JTextField(20);
        this.list = new JList();
        this.list.setSelectionMode(0);
        FilterLinkListCellRenderer filterCellRenderer = new FilterLinkListCellRenderer();
        this.list.setCellRenderer(filterCellRenderer);
        this.pane.setViewportView(this.list);
        this.add((Component)this.filterField, "North");
        this.add((Component)this.pane, "Center");
    }

    public JTextField getFilterField() {
        return this.filterField;
    }

    public JList getList() {
        return this.list;
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    public void setEventList(EventList<LinkValue> eventList) {
        this.setEventList(eventList, true);
    }

    public void setEventList(EventList<LinkValue> eventList, boolean addFirstIndexSelector) {
        FilterList textFilteredIssues = new FilterList(eventList, (MatcherEditor)new TextComponentMatcherEditor((JTextComponent)this.filterField, (TextFilterator)new LinkFilterator()));
        EventListModel listModel = new EventListModel((EventList)textFilteredIssues);
        if (addFirstIndexSelector) {
            textFilteredIssues.addListEventListener((ListEventListener)new ListEventListener<LinkValue>(){

                public void listChanged(ListEvent<LinkValue> linkValueListEvent) {
                    if (FilteredList.this.list.getModel().getSize() > 0) {
                        for (int i = 0; i < FilteredList.this.list.getModel().getSize(); ++i) {
                            if (FilteredList.this.list.getModel().getElementAt(i) == null) continue;
                            final int idx = i;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FilteredList.this.list.setSelectedIndex(idx);
                                }
                            });
                            break;
                        }
                    }
                }
            });
        }
        this.list.setModel(listModel);
        this.filterField.setText("");
    }
}

